/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.util.Arrays;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.authenticators.browser.ConditionalOtpFormAuthenticator;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

public class ConditionalOtpFormAuthenticatorFactory
implements AuthenticatorFactory {
    public static final String PROVIDER_ID = "auth-conditional-otp-form";
    public static final ConditionalOtpFormAuthenticator SINGLETON = new ConditionalOtpFormAuthenticator();
    public static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.OPTIONAL, AuthenticationExecutionModel.Requirement.DISABLED};

    public Authenticator create(KeycloakSession session) {
        return SINGLETON;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public String getReferenceCategory() {
        return "totp";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean isUserSetupAllowed() {
        return true;
    }

    @Override
    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    @Override
    public String getDisplayType() {
        return "Conditional OTP Form";
    }

    public String getHelpText() {
        return "Validates a OTP on a separate OTP form. Only shown if required based on the configured conditions.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        ProviderConfigProperty forceOtpUserAttribute = new ProviderConfigProperty();
        forceOtpUserAttribute.setType("String");
        forceOtpUserAttribute.setName("otpControlAttribute");
        forceOtpUserAttribute.setLabel("OTP control User Attribute");
        forceOtpUserAttribute.setHelpText("The name of the user attribute to explicitly control OTP auth. If attribute value is 'force' then OTP is always required. If value is 'skip' the OTP auth is skipped. Otherwise this check is ignored.");
        ProviderConfigProperty forceOtpRole = new ProviderConfigProperty();
        forceOtpRole.setType("Role");
        forceOtpRole.setName("forceOtpRole");
        forceOtpRole.setLabel("Force OTP for Role");
        forceOtpRole.setHelpText("OTP is always required if user has the given Role.");
        ProviderConfigProperty noOtpRequiredForHttpHeader = new ProviderConfigProperty();
        noOtpRequiredForHttpHeader.setType("String");
        noOtpRequiredForHttpHeader.setName("noOtpRequiredForHeaderPattern");
        noOtpRequiredForHttpHeader.setLabel("No OTP for Header");
        noOtpRequiredForHttpHeader.setHelpText("OTP required if a HTTP request header does not match the given pattern.Can be used to specify trusted networks via: X-Forwarded-Host: (1.2.3.4|1.2.3.5).In this case requests from 1.2.3.4 and 1.2.3.5 come from a trusted source.");
        noOtpRequiredForHttpHeader.setDefaultValue((Object)"");
        ProviderConfigProperty forceOtpForHttpHeader = new ProviderConfigProperty();
        forceOtpForHttpHeader.setType("String");
        forceOtpForHttpHeader.setName("forceOtpForHeaderPattern");
        forceOtpForHttpHeader.setLabel("Force OTP for Header");
        forceOtpForHttpHeader.setHelpText("OTP required if a HTTP request header matches the given pattern.");
        forceOtpForHttpHeader.setDefaultValue((Object)"");
        ProviderConfigProperty defaultOutcome = new ProviderConfigProperty();
        defaultOutcome.setType("List");
        defaultOutcome.setName("defaultOtpOutcome");
        defaultOutcome.setLabel("Fallback OTP handling");
        defaultOutcome.setDefaultValue(Arrays.asList("skip", "force"));
        defaultOutcome.setHelpText("What to do in case of every check abstains. Defaults to force OTP authentication.");
        return Arrays.asList(forceOtpUserAttribute, forceOtpRole, noOtpRequiredForHttpHeader, forceOtpForHttpHeader, defaultOutcome);
    }
}

