/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import javax.ws.rs.GET;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.AuthorizationEndpointBase;
import org.keycloak.protocol.oidc.OIDCLoginProtocol;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;

public class AuthorizationEndpoint
extends AuthorizationEndpointBase {
    private static final Logger logger = Logger.getLogger(AuthorizationEndpoint.class);
    public static final String CODE_AUTH_TYPE = "code";
    private ClientModel client;
    private ClientSessionModel clientSession;
    private Action action;
    private OIDCResponseType parsedResponseType;
    private String clientId;
    private String redirectUri;
    private String redirectUriParam;
    private String responseType;
    private String responseMode;
    private String state;
    private String scope;
    private String loginHint;
    private String prompt;
    private String nonce;
    private String idpHint;
    private String legacyResponseType;

    public AuthorizationEndpoint(AuthenticationManager authManager, RealmModel realm, EventBuilder event) {
        super(realm, event, authManager);
        event.event(EventType.LOGIN);
    }

    @GET
    public Response build() {
        MultivaluedMap params = this.uriInfo.getQueryParameters();
        this.clientId = (String)params.getFirst((Object)"client_id");
        this.responseType = (String)params.getFirst((Object)"response_type");
        this.responseMode = (String)params.getFirst((Object)"response_mode");
        this.redirectUriParam = (String)params.getFirst((Object)"redirect_uri");
        this.state = (String)params.getFirst((Object)"state");
        this.scope = (String)params.getFirst((Object)"scope");
        this.loginHint = (String)params.getFirst((Object)"login_hint");
        this.prompt = (String)params.getFirst((Object)"prompt");
        this.idpHint = (String)params.getFirst((Object)"kc_idp_hint");
        this.nonce = (String)params.getFirst((Object)"nonce");
        this.checkSsl();
        this.checkRealm();
        this.checkResponseType();
        this.checkClient();
        this.checkRedirectUri();
        this.createClientSession();
        switch (this.action) {
            case REGISTER: {
                return this.buildRegister();
            }
            case FORGOT_CREDENTIALS: {
                return this.buildForgotCredential();
            }
            case CODE: {
                return this.buildAuthorizationCodeAuthorizationResponse();
            }
        }
        throw new RuntimeException("Unknown action " + (Object)((Object)this.action));
    }

    public AuthorizationEndpoint legacy(String legacyResponseType) {
        logger.warnv("Invoking deprecated endpoint {0}", (Object)this.uriInfo.getRequestUri());
        this.legacyResponseType = legacyResponseType;
        return this;
    }

    public AuthorizationEndpoint register() {
        this.event.event(EventType.REGISTER);
        this.action = Action.REGISTER;
        if (!this.realm.isRegistrationAllowed()) {
            throw new ErrorPageException(this.session, "registrationNotAllowedMessage", new Object[0]);
        }
        return this;
    }

    public AuthorizationEndpoint forgotCredentials() {
        this.event.event(EventType.RESET_PASSWORD);
        this.action = Action.FORGOT_CREDENTIALS;
        if (!this.realm.isResetPasswordAllowed()) {
            throw new ErrorPageException(this.session, "resetCredentialNotAllowedMessage", new Object[0]);
        }
        return this;
    }

    private void checkSsl() {
        if (!this.uriInfo.getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            this.event.error("ssl_required");
            throw new ErrorPageException(this.session, "httpsRequiredMessage", new Object[0]);
        }
    }

    private void checkRealm() {
        if (!this.realm.isEnabled()) {
            this.event.error("realm_disabled");
            throw new ErrorPageException(this.session, "realmNotEnabledMessage", new Object[0]);
        }
    }

    private void checkClient() {
        if (this.clientId == null) {
            this.event.error("invalid_request");
            throw new ErrorPageException(this.session, "missingParameterMessage", "client_id");
        }
        this.event.client(this.clientId);
        this.client = this.realm.getClientByClientId(this.clientId);
        if (this.client == null) {
            this.event.error("client_not_found");
            throw new ErrorPageException(this.session, "clientNotFoundMessage", new Object[0]);
        }
        if (this.client.isBearerOnly()) {
            this.event.error("not_allowed");
            throw new ErrorPageException(this.session, "bearerOnlyMessage", new Object[0]);
        }
        if ((this.parsedResponseType.hasResponseType(CODE_AUTH_TYPE) || this.parsedResponseType.hasResponseType("none")) && !this.client.isStandardFlowEnabled()) {
            this.event.error("not_allowed");
            throw new ErrorPageException(this.session, "standardFlowDisabledMessage", new Object[0]);
        }
        if (this.parsedResponseType.isImplicitOrHybridFlow() && !this.client.isImplicitFlowEnabled()) {
            this.event.error("not_allowed");
            throw new ErrorPageException(this.session, "implicitFlowDisabledMessage", new Object[0]);
        }
        this.session.getContext().setClient(this.client);
    }

    private void checkResponseType() {
        if (this.responseType == null) {
            if (this.legacyResponseType != null) {
                this.responseType = this.legacyResponseType;
            } else {
                this.event.error("invalid_request");
                throw new ErrorPageException(this.session, "missingParameterMessage", "response_type");
            }
        }
        this.event.detail("response_type", this.responseType);
        try {
            this.parsedResponseType = OIDCResponseType.parse(this.responseType);
            if (this.action == null) {
                this.action = Action.CODE;
            }
        }
        catch (IllegalArgumentException iae) {
            logger.error((Object)iae.getMessage());
            this.event.error("invalid_request");
            throw new ErrorPageException(this.session, "invalidParameterMessage", "response_type");
        }
        try {
            OIDCResponseMode parsedResponseMode = OIDCResponseMode.parse(this.responseMode, this.parsedResponseType);
            this.event.detail("response_mode", parsedResponseMode.toString().toLowerCase());
            if (this.parsedResponseType.isImplicitOrHybridFlow() && parsedResponseMode == OIDCResponseMode.QUERY) {
                logger.error((Object)"Response_mode 'query' not allowed for implicit or hybrid flow");
                this.event.error("invalid_request");
                throw new ErrorPageException(this.session, "invalidParameterMessage", "response_mode");
            }
        }
        catch (IllegalArgumentException iae) {
            this.event.error("invalid_request");
            throw new ErrorPageException(this.session, "invalidParameterMessage", "response_mode");
        }
    }

    private void checkRedirectUri() {
        this.event.detail("redirect_uri", this.redirectUriParam);
        this.redirectUri = RedirectUtils.verifyRedirectUri(this.uriInfo, this.redirectUriParam, this.realm, this.client);
        if (this.redirectUri == null) {
            this.event.error("invalid_redirect_uri");
            throw new ErrorPageException(this.session, "invalidParameterMessage", "redirect_uri");
        }
    }

    private void createClientSession() {
        this.clientSession = this.session.sessions().createClientSession(this.realm, this.client);
        this.clientSession.setAuthMethod("openid-connect");
        this.clientSession.setRedirectUri(this.redirectUri);
        this.clientSession.setAction(ClientSessionModel.Action.AUTHENTICATE.name());
        this.clientSession.setNote("action_key", KeycloakModelUtils.generateCodeSecret());
        this.clientSession.setNote("response_type", this.responseType);
        this.clientSession.setNote("redirect_uri", this.redirectUriParam);
        this.clientSession.setNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
        if (this.state != null) {
            this.clientSession.setNote("state", this.state);
        }
        if (this.nonce != null) {
            this.clientSession.setNote("nonce", this.nonce);
        }
        if (this.scope != null) {
            this.clientSession.setNote("scope", this.scope);
        }
        if (this.loginHint != null) {
            this.clientSession.setNote("login_hint", this.loginHint);
        }
        if (this.prompt != null) {
            this.clientSession.setNote("prompt", this.prompt);
        }
        if (this.idpHint != null) {
            this.clientSession.setNote("kc_idp_hint", this.idpHint);
        }
        if (this.responseMode != null) {
            this.clientSession.setNote("response_mode", this.responseMode);
        }
    }

    private Response buildAuthorizationCodeAuthorizationResponse() {
        if (this.idpHint != null && !"".equals(this.idpHint)) {
            IdentityProviderModel identityProviderModel = this.realm.getIdentityProviderByAlias(this.idpHint);
            if (identityProviderModel == null) {
                return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setError("identityProviderNotFoundMessage", new Object[]{this.idpHint}).createErrorPage();
            }
            return this.buildRedirectToIdentityProvider(this.idpHint, new ClientSessionCode(this.realm, this.clientSession).getCode());
        }
        this.event.event(EventType.LOGIN);
        this.clientSession.setNote("auth_type", CODE_AUTH_TYPE);
        return this.handleBrowserAuthenticationRequest(this.clientSession, new OIDCLoginProtocol(this.session, this.realm, this.uriInfo, this.headers, this.event), this.prompt != null && this.prompt.equals("none"));
    }

    private Response buildRegister() {
        AuthenticationManager.expireIdentityCookie(this.realm, this.uriInfo, this.clientConnection);
        AuthenticationFlowModel flow = this.realm.getRegistrationFlow();
        String flowId = flow.getId();
        AuthenticationProcessor processor = this.createProcessor(this.clientSession, flowId, "registration");
        return processor.authenticate();
    }

    private Response buildForgotCredential() {
        AuthenticationManager.expireIdentityCookie(this.realm, this.uriInfo, this.clientConnection);
        AuthenticationFlowModel flow = this.realm.getResetCredentialsFlow();
        String flowId = flow.getId();
        AuthenticationProcessor processor = this.createProcessor(this.clientSession, flowId, "reset-credentials");
        return processor.authenticate();
    }

    private static enum Action {
        REGISTER,
        CODE,
        FORGOT_CREDENTIALS;

    }
}

