/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.adapter;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserModelDefaultMethods;
import org.keycloak.models.utils.DefaultRoles;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.storage.ReadOnlyException;

public class InMemoryUserAdapter
extends UserModelDefaultMethods.Streams {
    private Long createdTimestamp = Time.currentTimeMillis();
    private boolean emailVerified;
    private boolean enabled;
    private Set<String> roleIds = new HashSet<String>();
    private Set<String> groupIds = new HashSet<String>();
    private MultivaluedHashMap<String, String> attributes = new MultivaluedHashMap();
    private Set<String> requiredActions = new HashSet<String>();
    private String federationLink;
    private String serviceAccountClientLink;
    private KeycloakSession session;
    private RealmModel realm;
    private String id;
    private boolean readonly;

    public InMemoryUserAdapter(KeycloakSession session, RealmModel realm, String id) {
        this.session = session;
        this.realm = realm;
        this.id = id;
    }

    public String getUsername() {
        return this.getFirstAttribute("username");
    }

    public void setUsername(String username) {
        username = username == null ? null : username.toLowerCase();
        this.setSingleAttribute("username", username);
    }

    public void addDefaults() {
        DefaultRoles.addDefaultRoles((RealmModel)this.realm, (UserModel)this);
        this.realm.getDefaultGroupsStream().forEach(this::joinGroup);
    }

    public void setReadonly(boolean flag) {
        this.readonly = flag;
    }

    protected void checkReadonly() {
        if (this.readonly) {
            throw new ReadOnlyException("In memory user model is not writable");
        }
    }

    public String getId() {
        return this.id;
    }

    public Long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(Long timestamp) {
        this.checkReadonly();
        this.createdTimestamp = timestamp;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.checkReadonly();
        this.enabled = enabled;
    }

    public void setSingleAttribute(String name, String value) {
        this.checkReadonly();
        if ("username".equals(name) || "email".equals(name)) {
            value = KeycloakModelUtils.toLowerCaseSafe(value);
        }
        this.attributes.putSingle((Object)name, (Object)value);
    }

    public void setAttribute(String name, List<String> values) {
        String lowerCasedFirstValue;
        this.checkReadonly();
        if (("username".equals(name) || "email".equals(name)) && (lowerCasedFirstValue = KeycloakModelUtils.toLowerCaseSafe(values != null && values.size() > 0 ? values.get(0) : null)) != null) {
            values.set(0, lowerCasedFirstValue);
        }
        this.attributes.put((Object)name, values);
    }

    public void removeAttribute(String name) {
        this.checkReadonly();
        this.attributes.remove((Object)name);
    }

    public String getFirstAttribute(String name) {
        return (String)this.attributes.getFirst((Object)name);
    }

    public Stream<String> getAttributeStream(String name) {
        List value = (List)this.attributes.get((Object)name);
        return value != null ? value.stream() : Stream.empty();
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public Stream<String> getRequiredActionsStream() {
        return this.requiredActions.stream();
    }

    public void addRequiredAction(String action) {
        this.checkReadonly();
        this.requiredActions.add(action);
    }

    public void removeRequiredAction(String action) {
        this.checkReadonly();
        this.requiredActions.remove(action);
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        this.checkReadonly();
        this.requiredActions.add(action.name());
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.checkReadonly();
        this.requiredActions.remove(action.name());
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public void setEmailVerified(boolean verified) {
        this.checkReadonly();
        this.emailVerified = verified;
    }

    public Stream<GroupModel> getGroupsStream() {
        return this.groupIds.stream().map(arg_0 -> ((RealmModel)this.realm).getGroupById(arg_0));
    }

    public void joinGroup(GroupModel group) {
        this.checkReadonly();
        this.groupIds.add(group.getId());
    }

    public void leaveGroup(GroupModel group) {
        this.checkReadonly();
        this.groupIds.remove(group.getId());
    }

    public boolean isMemberOf(GroupModel group) {
        if (this.groupIds == null) {
            return false;
        }
        if (this.groupIds.contains(group.getId())) {
            return true;
        }
        return RoleUtils.isMember(this.getGroupsStream(), (GroupModel)group);
    }

    public String getFederationLink() {
        return this.federationLink;
    }

    public void setFederationLink(String link) {
        this.checkReadonly();
        this.federationLink = link;
    }

    public String getServiceAccountClientLink() {
        return this.serviceAccountClientLink;
    }

    public void setServiceAccountClientLink(String clientInternalId) {
        this.checkReadonly();
        this.serviceAccountClientLink = clientInternalId;
    }

    public Stream<RoleModel> getRealmRoleMappingsStream() {
        return this.getRoleMappingsStream().filter(RoleUtils::isRealmRole);
    }

    public Stream<RoleModel> getClientRoleMappingsStream(ClientModel app) {
        return this.getRoleMappingsStream().filter(r -> RoleUtils.isClientRole((RoleModel)r, (ClientModel)app));
    }

    public boolean hasRole(RoleModel role) {
        return RoleUtils.hasRole(this.getRoleMappingsStream(), (RoleModel)role) || RoleUtils.hasRoleFromGroup(this.getGroupsStream(), (RoleModel)role, (boolean)true);
    }

    public void grantRole(RoleModel role) {
        this.roleIds.add(role.getId());
    }

    public Stream<RoleModel> getRoleMappingsStream() {
        return this.roleIds.stream().map(arg_0 -> ((RealmModel)this.realm).getRoleById(arg_0));
    }

    public void deleteRoleMapping(RoleModel role) {
        this.roleIds.remove(role.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

