/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validation;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.userprofile.validation.ValidationResult;

public class AttributeValidationResult {
    private final String attributeKey;
    private final boolean changed;
    List<ValidationResult> validationResults;

    public List<ValidationResult> getValidationResults() {
        return this.validationResults;
    }

    public List<ValidationResult> getFailedValidations() {
        return this.validationResults == null ? null : this.validationResults.stream().filter(ValidationResult::isInvalid).collect(Collectors.toList());
    }

    public AttributeValidationResult(String attributeKey, boolean changed, List<ValidationResult> validationResults) {
        this.attributeKey = attributeKey;
        this.validationResults = validationResults;
        this.changed = changed;
    }

    public boolean isValid() {
        return this.validationResults.stream().allMatch(ValidationResult::isValid);
    }

    protected boolean isInvalid() {
        return !this.isValid();
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public String getField() {
        return this.attributeKey;
    }

    public boolean hasFailureOfErrorType(String ... errorKeys) {
        return this.validationResults != null && this.getFailedValidations().stream().anyMatch(o -> o.getErrorType() != null && Arrays.stream(errorKeys).anyMatch(a -> a.equals(o.getErrorType())));
    }
}

