/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ClientPoliciesRepresentation;
import org.keycloak.representations.idm.ClientPolicyRepresentation;
import org.keycloak.representations.idm.ClientProfileRepresentation;
import org.keycloak.representations.idm.ClientProfilesRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyModel;
import org.keycloak.services.clientpolicy.ClientProfileModel;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionConfiguration;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorConfiguration;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.util.JsonSerialization;

public class ClientPoliciesUtil {
    private static final Logger logger = Logger.getLogger(ClientPoliciesUtil.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static ClientProfilesRepresentation getClientProfilesRepresentation(KeycloakSession session, RealmModel realm) throws ClientPolicyException {
        ClientProfilesRepresentation profilesRep = null;
        String profilesJson = null;
        profilesJson = realm != null ? session.clientPolicy().getClientProfilesJsonString(realm) : session.clientPolicy().getClientProfilesOnKeycloakApp();
        if (profilesJson == null) {
            return new ClientProfilesRepresentation();
        }
        profilesRep = ClientPoliciesUtil.convertClientProfilesJsonToRepresentation(profilesJson);
        if (profilesRep == null) {
            return new ClientProfilesRepresentation();
        }
        return profilesRep;
    }

    public static Map<String, ClientProfileModel> getClientProfilesModel(KeycloakSession session, RealmModel realm) {
        String profilesJson = session.clientPolicy().getClientProfilesJsonString(realm);
        if (profilesJson == null) {
            return Collections.emptyMap();
        }
        ClientProfilesRepresentation profilesRep = null;
        try {
            profilesRep = ClientPoliciesUtil.convertClientProfilesJsonToRepresentation(profilesJson);
        }
        catch (ClientPolicyException e) {
            logger.warnv("Failed to serialize client profiles json string. err={0}, errDetail={1}", (Object)e.getError(), (Object)e.getErrorDetail());
            return Collections.emptyMap();
        }
        if (profilesRep == null || profilesRep.getProfiles() == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ClientProfileModel> profileMap = new HashMap<String, ClientProfileModel>();
        for (ClientProfileRepresentation profileRep : profilesRep.getProfiles()) {
            if (profileRep.getName() == null) continue;
            ClientProfileModel profileModel = new ClientProfileModel();
            profileModel.setName(profileRep.getName());
            profileModel.setDescription(profileRep.getDescription());
            if (profileRep.isBuiltin() != null) {
                profileModel.setBuiltin(profileRep.isBuiltin());
            } else {
                profileModel.setBuiltin(false);
            }
            if (profileRep.getExecutors() == null) {
                profileModel.setExecutors(new ArrayList<Object>());
                profileMap.put(profileRep.getName(), profileModel);
                continue;
            }
            ArrayList<Object> executors = new ArrayList<Object>();
            if (profileRep.getExecutors() != null) {
                profileRep.getExecutors().stream().forEach(obj -> {
                    JsonNode node = (JsonNode)objectMapper.convertValue(obj, JsonNode.class);
                    node.fields().forEachRemaining(executor -> {
                        ClientPolicyExecutorProvider provider = (ClientPolicyExecutorProvider)session.getProvider(ClientPolicyExecutorProvider.class, (String)executor.getKey());
                        if (provider == null) {
                            return;
                        }
                        try {
                            ClientPolicyExecutorConfiguration configuration = (ClientPolicyExecutorConfiguration)JsonSerialization.mapper.convertValue(executor.getValue(), provider.getExecutorConfigurationClass());
                            provider.setupConfiguration(configuration);
                            executors.add(provider);
                        }
                        catch (IllegalArgumentException iae) {
                            logger.warnv("failed for Configuration Setup :: error = {0}", (Object)iae.getMessage());
                        }
                    });
                });
            }
            profileModel.setExecutors(executors);
            profileMap.put(profileRep.getName(), profileModel);
        }
        return profileMap;
    }

    public static ClientProfilesRepresentation getValidatedBuiltinClientProfilesRepresentation(KeycloakSession session, InputStream is) throws ClientPolicyException {
        ClientProfilesRepresentation proposedProfilesRep = null;
        try {
            proposedProfilesRep = (ClientProfilesRepresentation)JsonSerialization.readValue((InputStream)is, ClientProfilesRepresentation.class);
        }
        catch (Exception e) {
            throw new ClientPolicyException("failed to deserialize builtin proposed client profiles json string.", e.getMessage());
        }
        if (proposedProfilesRep == null) {
            return new ClientProfilesRepresentation();
        }
        List proposedProfileRepList = proposedProfilesRep.getProfiles();
        if (proposedProfileRepList == null || proposedProfileRepList.isEmpty()) {
            return new ClientProfilesRepresentation();
        }
        if ((long)proposedProfileRepList.size() != proposedProfileRepList.stream().map(i -> i.getName()).distinct().count()) {
            throw new ClientPolicyException("proposed builtin client profile name duplicated.");
        }
        ClientProfilesRepresentation updatingProfilesRep = new ClientProfilesRepresentation();
        updatingProfilesRep.setProfiles(new ArrayList());
        List updatingProfileList = updatingProfilesRep.getProfiles();
        for (ClientProfileRepresentation proposedProfileRep : proposedProfilesRep.getProfiles()) {
            if (proposedProfileRep.getName() == null) {
                throw new ClientPolicyException("client profile without its name not allowed.");
            }
            if (proposedProfileRep.isBuiltin() == null || !proposedProfileRep.isBuiltin().booleanValue()) {
                throw new ClientPolicyException("ordinal client profile not allowed.");
            }
            ClientProfileRepresentation profileRep = new ClientProfileRepresentation();
            profileRep.setName(proposedProfileRep.getName());
            profileRep.setDescription(proposedProfileRep.getDescription());
            profileRep.setBuiltin(Boolean.TRUE);
            profileRep.setExecutors(new ArrayList());
            if (proposedProfileRep.getExecutors() != null) {
                for (Object executor : proposedProfileRep.getExecutors()) {
                    if (!ClientPoliciesUtil.isValidExecutor(session, executor)) {
                        throw new ClientPolicyException("proposed client profile contains the executor with its invalid configuration.");
                    }
                    profileRep.getExecutors().add(executor);
                }
            }
            updatingProfileList.add(profileRep);
        }
        return updatingProfilesRep;
    }

    public static String convertClientProfilesRepresentationToJson(ClientProfilesRepresentation reps) throws ClientPolicyException {
        return ClientPoliciesUtil.convertRepresentationToJson(reps);
    }

    private static ClientProfilesRepresentation convertClientProfilesJsonToRepresentation(String json) throws ClientPolicyException {
        return ClientPoliciesUtil.convertJsonToRepresentation(json, ClientProfilesRepresentation.class);
    }

    public static String getValidatedClientProfilesJson(KeycloakSession session, RealmModel realm, ClientProfilesRepresentation proposedProfilesRep) throws ClientPolicyException {
        return ClientPoliciesUtil.convertClientProfilesRepresentationToJson(ClientPoliciesUtil.getValidatedClientProfilesRepresentation(session, realm, proposedProfilesRep));
    }

    private static ClientProfilesRepresentation getValidatedClientProfilesRepresentation(KeycloakSession session, RealmModel realm, ClientProfilesRepresentation proposedProfilesRep) throws ClientPolicyException {
        ArrayList proposedProfileRepList;
        if (proposedProfilesRep == null) {
            proposedProfilesRep = new ClientProfilesRepresentation();
        }
        if (realm == null) {
            throw new ClientPolicyException("realm not specified.");
        }
        ClientProfilesRepresentation existingProfilesRep = null;
        String existingProfilesJson = session.clientPolicy().getClientProfilesJsonString(realm);
        if (existingProfilesJson != null) {
            existingProfilesRep = ClientPoliciesUtil.convertClientProfilesJsonToRepresentation(existingProfilesJson);
            if (existingProfilesRep == null) {
                existingProfilesRep = new ClientProfilesRepresentation();
            }
        } else {
            existingProfilesRep = new ClientProfilesRepresentation();
        }
        if ((proposedProfileRepList = proposedProfilesRep.getProfiles()) == null || proposedProfileRepList.isEmpty()) {
            proposedProfileRepList = new ArrayList();
            proposedProfilesRep.setProfiles(new ArrayList());
        }
        if ((long)proposedProfileRepList.size() != proposedProfileRepList.stream().map(i -> i.getName()).distinct().count()) {
            throw new ClientPolicyException("proposed client profile name duplicated.");
        }
        ClientProfilesRepresentation updatingProfilesRep = new ClientProfilesRepresentation();
        updatingProfilesRep.setProfiles(new ArrayList());
        List updatingProfileList = updatingProfilesRep.getProfiles();
        List existingProfileList = existingProfilesRep.getProfiles();
        if (existingProfileList != null && !existingProfileList.isEmpty()) {
            existingProfileList.stream().filter(i -> i.isBuiltin()).forEach(i -> updatingProfileList.add(i));
        }
        for (ClientProfileRepresentation proposedProfileRep : proposedProfilesRep.getProfiles()) {
            if (proposedProfileRep.getName() == null) {
                throw new ClientPolicyException("client profile without its name not allowed.");
            }
            if (proposedProfileRep.isBuiltin() != null && proposedProfileRep.isBuiltin().booleanValue()) {
                throw new ClientPolicyException("newly builtin proposed client profile not allowed.");
            }
            if (updatingProfileList.stream().anyMatch(i -> proposedProfileRep.getName().equals(i.getName()))) {
                throw new ClientPolicyException("proposed client profile name is the same one of the builtin profile.");
            }
            ClientProfileRepresentation profileRep = new ClientProfileRepresentation();
            profileRep.setName(proposedProfileRep.getName());
            profileRep.setDescription(proposedProfileRep.getDescription());
            profileRep.setBuiltin(Boolean.FALSE);
            profileRep.setExecutors(new ArrayList());
            if (proposedProfileRep.getExecutors() != null) {
                for (Object executor : proposedProfileRep.getExecutors()) {
                    if (!ClientPoliciesUtil.isValidExecutor(session, executor)) {
                        throw new ClientPolicyException("proposed client profile contains the executor with its invalid configuration.");
                    }
                    profileRep.getExecutors().add(executor);
                }
            }
            updatingProfileList.add(profileRep);
        }
        return updatingProfilesRep;
    }

    public static ClientProfilesRepresentation getValidatedClientProfilesRepresentation(KeycloakSession session, RealmModel realm, String profilesJson) throws ClientPolicyException {
        if (profilesJson == null) {
            throw new ClientPolicyException("no client profiles json.");
        }
        ClientProfilesRepresentation proposedProfilesRep = ClientPoliciesUtil.convertClientProfilesJsonToRepresentation(profilesJson);
        return ClientPoliciesUtil.getValidatedClientProfilesRepresentation(session, realm, proposedProfilesRep);
    }

    private static boolean isValidExecutor(KeycloakSession session, Object executor) {
        return ClientPoliciesUtil.isValidComponent(session, executor, "executor", providerId -> {
            Set providerSet = session.listProviderIds(ClientPolicyExecutorProvider.class);
            if (providerSet != null && providerSet.contains(providerId)) {
                return true;
            }
            logger.warnv("no executor provider found. providerId = {0}", providerId);
            return false;
        });
    }

    public static ClientPoliciesRepresentation getClientPoliciesRepresentation(KeycloakSession session, RealmModel realm) throws ClientPolicyException {
        ClientPoliciesRepresentation policiesRep = null;
        String policiesJson = null;
        policiesJson = realm != null ? session.clientPolicy().getClientPoliciesJsonString(realm) : session.clientPolicy().getClientPoliciesOnKeycloakApp();
        if (policiesJson == null) {
            return new ClientPoliciesRepresentation();
        }
        policiesRep = ClientPoliciesUtil.convertClientPoliciesJsonToRepresentation(policiesJson);
        if (policiesRep == null) {
            return new ClientPoliciesRepresentation();
        }
        return policiesRep;
    }

    public static List<ClientPolicyModel> getEnabledClientProfilesModel(KeycloakSession session, RealmModel realm) {
        String policiesJson = session.clientPolicy().getClientPoliciesJsonString(realm);
        if (policiesJson == null) {
            return Collections.emptyList();
        }
        ClientPoliciesRepresentation policiesRep = null;
        try {
            policiesRep = ClientPoliciesUtil.convertClientPoliciesJsonToRepresentation(policiesJson);
        }
        catch (ClientPolicyException e) {
            logger.warnv("Failed to serialize client policies json string. err={0}, errDetail={1}", (Object)e.getError(), (Object)e.getErrorDetail());
            return Collections.emptyList();
        }
        if (policiesRep == null || policiesRep.getPolicies() == null) {
            return Collections.emptyList();
        }
        ArrayList<ClientPolicyModel> policyList = new ArrayList<ClientPolicyModel>();
        for (ClientPolicyRepresentation policyRep : policiesRep.getPolicies()) {
            if (policyRep.getName() == null || policyRep.isEnable() == null || !policyRep.isEnable().booleanValue()) continue;
            ClientPolicyModel policyModel = new ClientPolicyModel();
            policyModel.setName(policyRep.getName());
            policyModel.setDescription(policyRep.getDescription());
            policyModel.setEnable(true);
            if (policyRep.isBuiltin() != null) {
                policyModel.setBuiltin(policyRep.isBuiltin());
            } else {
                policyModel.setBuiltin(false);
            }
            ArrayList<Object> conditions = new ArrayList<Object>();
            if (policyRep.getConditions() != null) {
                policyRep.getConditions().stream().forEach(obj -> {
                    JsonNode node = (JsonNode)objectMapper.convertValue(obj, JsonNode.class);
                    node.fields().forEachRemaining(condition -> {
                        ClientPolicyConditionProvider provider = (ClientPolicyConditionProvider)session.getProvider(ClientPolicyConditionProvider.class, (String)condition.getKey());
                        if (provider == null) {
                            return;
                        }
                        try {
                            ClientPolicyConditionConfiguration configuration = (ClientPolicyConditionConfiguration)JsonSerialization.mapper.convertValue(condition.getValue(), provider.getConditionConfigurationClass());
                            provider.setupConfiguration(configuration);
                            conditions.add(provider);
                        }
                        catch (IllegalArgumentException iae) {
                            logger.warnv("failed for Configuration Setup :: error = {0}", (Object)iae.getMessage());
                        }
                    });
                });
            }
            policyModel.setConditions(conditions);
            if (policyRep.getProfiles() != null) {
                policyModel.setProfiles(policyRep.getProfiles().stream().collect(Collectors.toList()));
            }
            policyList.add(policyModel);
        }
        return policyList;
    }

    public static ClientPoliciesRepresentation getValidatedBuiltinClientPoliciesRepresentation(KeycloakSession session, InputStream is) throws ClientPolicyException {
        List proposedPolicyRepList;
        ClientPoliciesRepresentation proposedPoliciesRep = null;
        try {
            proposedPoliciesRep = (ClientPoliciesRepresentation)JsonSerialization.readValue((InputStream)is, ClientPoliciesRepresentation.class);
        }
        catch (Exception e) {
            throw new ClientPolicyException("failed to deserialize builtin proposed client policies json string.", e.getMessage());
        }
        if (proposedPoliciesRep == null) {
            proposedPoliciesRep = new ClientPoliciesRepresentation();
        }
        if ((proposedPolicyRepList = proposedPoliciesRep.getPolicies()) == null || proposedPolicyRepList.isEmpty()) {
            return new ClientPoliciesRepresentation();
        }
        if ((long)proposedPolicyRepList.size() != proposedPolicyRepList.stream().map(i -> i.getName()).distinct().count()) {
            throw new ClientPolicyException("proposed builtin client policy name duplicated.");
        }
        ClientPoliciesRepresentation updatingPoliciesRep = new ClientPoliciesRepresentation();
        updatingPoliciesRep.setPolicies(new ArrayList());
        List updatingPoliciesList = updatingPoliciesRep.getPolicies();
        for (ClientPolicyRepresentation proposedPolicyRep : proposedPoliciesRep.getPolicies()) {
            if (proposedPolicyRep.getName() == null) {
                throw new ClientPolicyException("proposed client policy name missing.");
            }
            if (proposedPolicyRep.isBuiltin() == null || !proposedPolicyRep.isBuiltin().booleanValue()) {
                throw new ClientPolicyException("ordinal client policy not allowed.");
            }
            ClientPolicyRepresentation policyRep = new ClientPolicyRepresentation();
            policyRep.setName(proposedPolicyRep.getName());
            policyRep.setDescription(proposedPolicyRep.getDescription());
            policyRep.setBuiltin(Boolean.TRUE);
            Boolean enabled = proposedPolicyRep.isEnable() != null ? proposedPolicyRep.isEnable() : Boolean.FALSE;
            policyRep.setEnable(enabled);
            policyRep.setConditions(new ArrayList());
            if (proposedPolicyRep.getConditions() != null) {
                for (Object condition : proposedPolicyRep.getConditions()) {
                    if (!ClientPoliciesUtil.isValidCondition(session, condition)) {
                        throw new ClientPolicyException("the proposed client policy contains the condition with its invalid configuration.");
                    }
                    policyRep.getConditions().add(condition);
                }
            }
            HashSet existingProfileNames = new HashSet();
            ClientProfilesRepresentation reps = ClientPoliciesUtil.getClientProfilesRepresentation(session, null);
            reps.getProfiles().stream().map(profile -> profile.getName()).forEach(profileName -> existingProfileNames.add(profileName));
            policyRep.setProfiles(new ArrayList());
            if (proposedPolicyRep.getProfiles() != null) {
                for (String profileName2 : proposedPolicyRep.getProfiles()) {
                    if (existingProfileNames.contains(profileName2)) continue;
                    throw new ClientPolicyException("referring not existing client profile not allowed.");
                }
                proposedPolicyRep.getProfiles().stream().distinct().forEach(profileName -> policyRep.getProfiles().add(profileName));
            }
            updatingPoliciesList.add(policyRep);
        }
        return updatingPoliciesRep;
    }

    public static String convertClientPoliciesRepresentationToJson(ClientPoliciesRepresentation reps) throws ClientPolicyException {
        return ClientPoliciesUtil.convertRepresentationToJson(reps);
    }

    private static ClientPoliciesRepresentation convertClientPoliciesJsonToRepresentation(String json) throws ClientPolicyException {
        return ClientPoliciesUtil.convertJsonToRepresentation(json, ClientPoliciesRepresentation.class);
    }

    public static String getValidatedClientPoliciesJson(KeycloakSession session, RealmModel realm, ClientPoliciesRepresentation proposedPoliciesRep) throws ClientPolicyException {
        return ClientPoliciesUtil.convertClientPoliciesRepresentationToJson(ClientPoliciesUtil.getValidatedClientPoliciesRepresentation(session, realm, proposedPoliciesRep));
    }

    private static ClientPoliciesRepresentation getValidatedClientPoliciesRepresentation(KeycloakSession session, RealmModel realm, ClientPoliciesRepresentation proposedPoliciesRep) throws ClientPolicyException {
        ArrayList proposedPolicyRepList;
        if (proposedPoliciesRep == null) {
            proposedPoliciesRep = new ClientPoliciesRepresentation();
        }
        if (realm == null) {
            throw new ClientPolicyException("realm not specified.");
        }
        ClientPoliciesRepresentation existingPoliciesRep = null;
        String existingPoliciesJson = session.clientPolicy().getClientPoliciesJsonString(realm);
        if (existingPoliciesJson != null) {
            existingPoliciesRep = ClientPoliciesUtil.convertClientPoliciesJsonToRepresentation(existingPoliciesJson);
            if (existingPoliciesRep == null) {
                existingPoliciesRep = new ClientPoliciesRepresentation();
            }
        } else {
            existingPoliciesRep = new ClientPoliciesRepresentation();
        }
        if ((proposedPolicyRepList = proposedPoliciesRep.getPolicies()) == null || proposedPolicyRepList.isEmpty()) {
            proposedPolicyRepList = new ArrayList();
            proposedPoliciesRep.setPolicies(new ArrayList());
        }
        if ((long)proposedPolicyRepList.size() != proposedPolicyRepList.stream().map(i -> i.getName()).distinct().count()) {
            throw new ClientPolicyException("proposed client policy name duplicated.");
        }
        ClientPoliciesRepresentation updatingPoliciesRep = new ClientPoliciesRepresentation();
        updatingPoliciesRep.setPolicies(new ArrayList());
        List updatingPoliciesList = updatingPoliciesRep.getPolicies();
        List existingPoliciesList = existingPoliciesRep.getPolicies();
        if (existingPoliciesList != null && !existingPoliciesList.isEmpty()) {
            existingPoliciesList.stream().filter(i -> i.isBuiltin()).forEach(i -> updatingPoliciesList.add(i));
        }
        for (ClientPolicyRepresentation proposedPolicyRep : proposedPoliciesRep.getPolicies()) {
            Boolean enabled;
            if (proposedPolicyRep.getName() == null) {
                throw new ClientPolicyException("proposed client policy name missing.");
            }
            Boolean bl = enabled = proposedPolicyRep.isEnable() != null ? proposedPolicyRep.isEnable() : Boolean.FALSE;
            if (proposedPolicyRep.isBuiltin() != null && proposedPolicyRep.isBuiltin().booleanValue()) {
                if (updatingPoliciesList.stream().anyMatch(i -> i.getName().equals(proposedPolicyRep.getName()))) {
                    updatingPoliciesList.stream().filter(i -> i.getName().equals(proposedPolicyRep.getName())).forEach(i -> i.setEnable(enabled));
                    continue;
                }
                throw new ClientPolicyException("newly builtin proposed client policy not allowed.");
            }
            ClientPolicyRepresentation policyRep = new ClientPolicyRepresentation();
            policyRep.setName(proposedPolicyRep.getName());
            policyRep.setDescription(proposedPolicyRep.getDescription());
            policyRep.setBuiltin(Boolean.FALSE);
            policyRep.setEnable(enabled);
            policyRep.setConditions(new ArrayList());
            if (proposedPolicyRep.getConditions() != null) {
                for (Object condition : proposedPolicyRep.getConditions()) {
                    if (!ClientPoliciesUtil.isValidCondition(session, condition)) {
                        throw new ClientPolicyException("the proposed client policy contains the condition with its invalid configuration.");
                    }
                    policyRep.getConditions().add(condition);
                }
            }
            HashSet existingProfileNames = new HashSet();
            ClientProfilesRepresentation reps = ClientPoliciesUtil.getClientProfilesRepresentation(session, realm);
            if (reps.getProfiles() != null) {
                reps.getProfiles().stream().map(profile -> profile.getName()).forEach(profileName -> existingProfileNames.add(profileName));
            }
            policyRep.setProfiles(new ArrayList());
            if (proposedPolicyRep.getProfiles() != null) {
                for (String profileName2 : proposedPolicyRep.getProfiles()) {
                    if (existingProfileNames.contains(profileName2)) continue;
                    throw new ClientPolicyException("referring not existing client profile not allowed.");
                }
                proposedPolicyRep.getProfiles().stream().distinct().forEach(profileName -> policyRep.getProfiles().add(profileName));
            }
            updatingPoliciesList.add(policyRep);
        }
        return updatingPoliciesRep;
    }

    public static ClientPoliciesRepresentation getValidatedClientPoliciesRepresentation(KeycloakSession session, RealmModel realm, String policiesJson) throws ClientPolicyException {
        if (policiesJson == null) {
            throw new ClientPolicyException("no client policies json.");
        }
        ClientPoliciesRepresentation proposedPoliciesRep = ClientPoliciesUtil.convertClientPoliciesJsonToRepresentation(policiesJson);
        return ClientPoliciesUtil.getValidatedClientPoliciesRepresentation(session, realm, proposedPoliciesRep);
    }

    private static boolean isValidCondition(KeycloakSession session, Object condition) {
        return ClientPoliciesUtil.isValidComponent(session, condition, "condition", providerId -> {
            Set providerSet = session.listProviderIds(ClientPolicyConditionProvider.class);
            if (providerSet != null && providerSet.contains(providerId)) {
                return true;
            }
            logger.warnv("no executor provider found. providerId = {0}", providerId);
            return false;
        });
    }

    private static boolean isValidComponent(KeycloakSession session, Object obj, String type, Predicate<String> f) {
        JsonNode node = null;
        try {
            node = (JsonNode)objectMapper.convertValue(obj, JsonNode.class);
        }
        catch (IllegalArgumentException iae) {
            logger.warnv("invalid json string representating {0}. err={1}", (Object)type, (Object)iae.getMessage());
            return false;
        }
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            if (f.test((String)entry.getKey())) continue;
            return false;
        }
        return true;
    }

    private static String convertRepresentationToJson(Object reps) throws ClientPolicyException {
        if (reps == null) {
            return null;
        }
        String json = null;
        try {
            json = objectMapper.writeValueAsString(reps);
        }
        catch (JsonProcessingException jpe) {
            throw new ClientPolicyException(jpe.getMessage());
        }
        return json;
    }

    private static <T> T convertJsonToRepresentation(String json, Class<T> type) throws ClientPolicyException {
        if (json == null) {
            throw new ClientPolicyException("no json.");
        }
        Object rep = null;
        try {
            rep = JsonSerialization.readValue((String)json, type);
        }
        catch (IOException ioe) {
            throw new ClientPolicyException("failed to deserialize.", ioe.getMessage());
        }
        return (T)rep;
    }
}

