/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.validation.AttributeValidationResult;

public class UserProfileValidationResult {
    List<AttributeValidationResult> attributeValidationResults;
    private final UserProfile updatedProfile;

    public UserProfileValidationResult(List<AttributeValidationResult> attributeValidationResults, UserProfile updatedProfile) {
        this.attributeValidationResults = attributeValidationResults;
        this.updatedProfile = updatedProfile;
    }

    public List<AttributeValidationResult> getValidationResults() {
        return this.attributeValidationResults;
    }

    public List<AttributeValidationResult> getErrors() {
        return this.attributeValidationResults.stream().filter(AttributeValidationResult::isInvalid).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean hasFailureOfErrorType(String ... errorKeys) {
        return this.attributeValidationResults != null && this.attributeValidationResults.stream().anyMatch(attributeValidationResult -> attributeValidationResult.hasFailureOfErrorType(errorKeys));
    }

    public boolean hasAttributeChanged(String attribute) {
        return ((AttributeValidationResult)this.attributeValidationResults.stream().filter(o -> o.getField().equals(attribute)).collect(Collectors.toList()).get(0)).hasChanged();
    }

    public UserProfile getProfile() {
        return this.updatedProfile;
    }
}

