/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.keycloak.models.ClientScopeProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeValidatorMetadata;

public final class AttributeMetadata {
    public static final Predicate<AttributeContext> ALWAYS_TRUE = context -> true;
    public static final Predicate<AttributeContext> ALWAYS_FALSE = context -> false;
    private final String attributeName;
    private final Predicate<AttributeContext> selector;
    private final Predicate<AttributeContext> writeAllowed;
    private final Predicate<AttributeContext> required;
    private final Predicate<AttributeContext> readAllowed;
    private List<AttributeValidatorMetadata> validators;
    private Map<String, Object> annotations;

    AttributeMetadata(String attributeName) {
        this(attributeName, ALWAYS_TRUE, ALWAYS_TRUE, ALWAYS_TRUE, ALWAYS_TRUE);
    }

    AttributeMetadata(String attributeName, Predicate<AttributeContext> writeAllowed, Predicate<AttributeContext> required) {
        this(attributeName, ALWAYS_TRUE, writeAllowed, required, ALWAYS_TRUE);
    }

    AttributeMetadata(String attributeName, Predicate<AttributeContext> selector) {
        this(attributeName, selector, ALWAYS_FALSE, ALWAYS_TRUE, ALWAYS_TRUE);
    }

    AttributeMetadata(String attributeName, List<String> scopes, Predicate<AttributeContext> writeAllowed, Predicate<AttributeContext> required) {
        this(attributeName, context -> {
            KeycloakSession session = context.getSession();
            AuthenticationSessionModel authSession = session.getContext().getAuthenticationSession();
            if (authSession == null) {
                return false;
            }
            ClientScopeProvider clientScopes = session.clientScopes();
            RealmModel realm = session.getContext().getRealm();
            if (authSession.getClientScopes().stream().anyMatch(scopes::contains)) {
                return true;
            }
            return authSession.getClientScopes().stream().map(id -> clientScopes.getClientScopeById(realm, id).getName()).anyMatch(scopes::contains);
        }, writeAllowed, required, ALWAYS_TRUE);
    }

    AttributeMetadata(String attributeName, Predicate<AttributeContext> selector, Predicate<AttributeContext> writeAllowed, Predicate<AttributeContext> required, Predicate<AttributeContext> readAllowed) {
        this.attributeName = attributeName;
        this.selector = selector;
        this.writeAllowed = writeAllowed;
        this.required = required;
        this.readAllowed = readAllowed;
    }

    public String getName() {
        return this.attributeName;
    }

    public boolean isSelected(AttributeContext context) {
        return this.selector.test(context);
    }

    public boolean isReadOnly(AttributeContext context) {
        return !this.writeAllowed.test(context);
    }

    public boolean canView(AttributeContext context) {
        return this.readAllowed.test(context);
    }

    public boolean isRequired(AttributeContext context) {
        return this.required == null || this.required.test(context);
    }

    public List<AttributeValidatorMetadata> getValidators() {
        return this.validators;
    }

    public AttributeMetadata addValidator(List<AttributeValidatorMetadata> validators) {
        if (this.validators == null) {
            this.validators = new ArrayList<AttributeValidatorMetadata>();
        }
        this.validators.addAll(validators.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        return this;
    }

    public AttributeMetadata addValidator(AttributeValidatorMetadata validator) {
        this.addValidator(Arrays.asList(validator));
        return this;
    }

    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    public AttributeMetadata addAnnotations(Map<String, Object> annotations) {
        if (annotations != null) {
            if (this.annotations == null) {
                this.annotations = new HashMap<String, Object>();
            }
            this.annotations.putAll(annotations);
        }
        return this;
    }

    public AttributeMetadata clone() {
        AttributeMetadata cloned = new AttributeMetadata(this.attributeName, this.selector, this.writeAllowed, this.required, this.readAllowed);
        if (this.validators != null) {
            cloned.addValidator(this.validators);
        }
        if (this.annotations != null) {
            cloned.addAnnotations(this.annotations);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AttributeMetadata)) {
            return false;
        }
        AttributeMetadata that = (AttributeMetadata)o;
        return that.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.attributeName.hashCode();
    }
}

