/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.store;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;

public interface PolicyStore {
    public Policy create(AbstractPolicyRepresentation var1, ResourceServer var2);

    public void delete(String var1);

    public Policy findById(String var1, String var2);

    public Policy findByName(String var1, String var2);

    public List<Policy> findByResourceServer(String var1);

    public List<Policy> findByResourceServer(Map<Policy.FilterOption, String[]> var1, String var2, int var3, int var4);

    default public List<Policy> findByResource(String resourceId, String resourceServerId) {
        LinkedList<Policy> result = new LinkedList<Policy>();
        this.findByResource(resourceId, resourceServerId, result::add);
        return result;
    }

    public void findByResource(String var1, String var2, Consumer<Policy> var3);

    default public List<Policy> findByResourceType(String resourceType, String resourceServerId) {
        LinkedList<Policy> result = new LinkedList<Policy>();
        this.findByResourceType(resourceType, resourceServerId, result::add);
        return result;
    }

    public List<Policy> findByScopeIds(List<String> var1, String var2);

    default public List<Policy> findByScopeIds(List<String> scopeIds, String resourceId, String resourceServerId) {
        LinkedList<Policy> result = new LinkedList<Policy>();
        this.findByScopeIds(scopeIds, resourceId, resourceServerId, result::add);
        return result;
    }

    public void findByScopeIds(List<String> var1, String var2, String var3, Consumer<Policy> var4);

    public List<Policy> findByType(String var1, String var2);

    public List<Policy> findDependentPolicies(String var1, String var2);

    public void findByResourceType(String var1, String var2, Consumer<Policy> var3);
}

