/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.keycloak.authorization.permission.evaluator.Evaluators;
import org.keycloak.authorization.policy.evaluation.DefaultPolicyEvaluator;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;

public final class AuthorizationProvider
implements Provider {
    private final DefaultPolicyEvaluator policyEvaluator;
    private final Executor scheduller;
    private final StoreFactory storeFactory;
    private final List<PolicyProviderFactory> policyProviderFactories;
    private final KeycloakSession keycloakSession;
    private final RealmModel realm;

    public AuthorizationProvider(KeycloakSession session, RealmModel realm, StoreFactory storeFactory, Executor scheduller) {
        this.keycloakSession = session;
        this.realm = realm;
        this.storeFactory = storeFactory;
        this.scheduller = scheduller;
        this.policyProviderFactories = this.configurePolicyProviderFactories(session);
        this.policyEvaluator = new DefaultPolicyEvaluator(this, this.policyProviderFactories);
    }

    public AuthorizationProvider(KeycloakSession session, RealmModel realm, StoreFactory storeFactory) {
        this(session, realm, storeFactory, Runnable::run);
    }

    public Evaluators evaluators() {
        return new Evaluators(this.policyProviderFactories, this.policyEvaluator, this.scheduller);
    }

    public StoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    public List<PolicyProviderFactory> getProviderFactories() {
        return this.policyProviderFactories;
    }

    public <F extends PolicyProviderFactory> F getProviderFactory(String type) {
        return (F)((PolicyProviderFactory)this.getProviderFactories().stream().filter(policyProviderFactory -> policyProviderFactory.getId().equals(type)).findFirst().orElse(null));
    }

    public KeycloakSession getKeycloakSession() {
        return this.keycloakSession;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    private List<PolicyProviderFactory> configurePolicyProviderFactories(KeycloakSession session) {
        List providerFactories = session.getKeycloakSessionFactory().getProviderFactories(PolicyProvider.class);
        if (providerFactories.isEmpty()) {
            throw new RuntimeException("Could not find any policy provider.");
        }
        return providerFactories.stream().map(providerFactory -> (PolicyProviderFactory)providerFactory).collect(Collectors.toList());
    }

    public void close() {
    }
}

