/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.store.syncronization;

import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.store.syncronization.Synchronizer;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderFactory;

public class RealmSynchronizer
implements Synchronizer<RealmModel.RealmRemovedEvent> {
    @Override
    public void synchronize(RealmModel.RealmRemovedEvent event, KeycloakSessionFactory factory) {
        ProviderFactory providerFactory = factory.getProviderFactory(AuthorizationProvider.class);
        AuthorizationProvider authorizationProvider = (AuthorizationProvider)providerFactory.create(event.getKeycloakSession());
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        event.getRealm().getClients().forEach(clientModel -> {
            ResourceServer resourceServer = storeFactory.getResourceServerStore().findByClient(clientModel.getId());
            if (resourceServer != null) {
                String id = resourceServer.getId();
                storeFactory.getResourceServerStore().delete(id);
            }
        });
    }
}

