/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.DefaultDataMarshaller;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderDataMarshaller;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.sessions.AuthenticationSessionModel;

public abstract class AbstractIdentityProvider<C extends IdentityProviderModel>
implements IdentityProvider<C> {
    public static final String ACCOUNT_LINK_URL = "account-link-url";
    protected final KeycloakSession session;
    private final C config;

    public AbstractIdentityProvider(KeycloakSession session, C config) {
        this.session = session;
        this.config = config;
    }

    public C getConfig() {
        return this.config;
    }

    @Override
    public Response export(UriInfo uriInfo, RealmModel realm, String format) {
        return Response.noContent().build();
    }

    public void close() {
    }

    @Override
    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return null;
    }

    @Override
    public Response performLogin(AuthenticationRequest request) {
        return null;
    }

    @Override
    public Response keycloakInitiatedBrowserLogout(KeycloakSession session, UserSessionModel userSession, UriInfo uriInfo, RealmModel realm) {
        return null;
    }

    @Override
    public void backchannelLogout(KeycloakSession session, UserSessionModel userSession, UriInfo uriInfo, RealmModel realm) {
    }

    public Response exchangeNotSupported() {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("error", "invalid_target");
        error.put("error_description", "target_exchange_unsupported");
        return Response.status((int)400).entity(error).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public Response exchangeNotLinked(UriInfo uriInfo, ClientModel authorizedClient, UserSessionModel tokenUserSession, UserModel tokenSubject, AccessToken token) {
        return this.exchangeErrorResponse(uriInfo, authorizedClient, tokenUserSession, token, "invalid_target");
    }

    protected Response exchangeErrorResponse(UriInfo uriInfo, ClientModel authorizedClient, UserSessionModel tokenUserSession, AccessToken token, String reason) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("error", "invalid_target");
        error.put("error_description", reason);
        String accountLinkUrl = this.getLinkingUrl(uriInfo, authorizedClient, tokenUserSession, token);
        if (accountLinkUrl != null) {
            error.put(ACCOUNT_LINK_URL, accountLinkUrl);
        }
        return Response.status((int)400).entity(error).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected String getLinkingUrl(UriInfo uriInfo, ClientModel authorizedClient, UserSessionModel tokenUserSession, AccessToken token) {
        if (authorizedClient.getClientId().equals(token.getIssuedFor())) {
            String provider = this.getConfig().getAlias();
            String clientId = authorizedClient.getClientId();
            String nonce = UUID.randomUUID().toString();
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            String input = nonce + tokenUserSession.getId() + clientId + provider;
            byte[] check = md.digest(input.getBytes(StandardCharsets.UTF_8));
            String hash = Base64Url.encode((byte[])check);
            return KeycloakUriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("/realms/{realm}/broker/{provider}/link").queryParam("nonce", new Object[]{nonce}).queryParam("hash", new Object[]{hash}).queryParam("client_id", new Object[]{clientId}).build(new Object[]{authorizedClient.getRealm().getName(), provider}).toString();
        }
        return null;
    }

    public Response exchangeTokenExpired(UriInfo uriInfo, ClientModel authorizedClient, UserSessionModel tokenUserSession, UserModel tokenSubject, AccessToken token) {
        return this.exchangeErrorResponse(uriInfo, authorizedClient, tokenUserSession, token, "token_expired");
    }

    public Response exchangeUnsupportedRequiredType() {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("error", "invalid_target");
        error.put("error_description", "response_token_type_unsupported");
        return Response.status((int)400).entity(error).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Override
    public void authenticationFinished(AuthenticationSessionModel authSession, BrokeredIdentityContext context) {
    }

    @Override
    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, BrokeredIdentityContext context) {
    }

    @Override
    public void importNewUser(KeycloakSession session, RealmModel realm, UserModel user, BrokeredIdentityContext context) {
    }

    @Override
    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, BrokeredIdentityContext context) {
    }

    @Override
    public IdentityProviderDataMarshaller getMarshaller() {
        return new DefaultDataMarshaller();
    }
}

