/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider.util;

import java.util.regex.Pattern;

public class IdentityBrokerState {
    private String decodedState;
    private String clientId;
    private String encodedState;
    private static final Pattern DOT = Pattern.compile("\\.");

    private IdentityBrokerState() {
    }

    public static IdentityBrokerState decoded(String decodedState, String clientId) {
        IdentityBrokerState state = new IdentityBrokerState();
        state.decodedState = decodedState;
        state.clientId = clientId;
        return state;
    }

    public static IdentityBrokerState encoded(String encodedState) {
        IdentityBrokerState state = new IdentityBrokerState();
        state.encodedState = encodedState;
        return state;
    }

    public String getDecodedState() {
        if (this.decodedState == null) {
            this.decode();
        }
        return this.decodedState;
    }

    public String getClientId() {
        if (this.decodedState == null) {
            this.decode();
        }
        return this.clientId;
    }

    public String getEncodedState() {
        if (this.encodedState == null) {
            this.encode();
        }
        return this.encodedState;
    }

    private void decode() {
        String[] decoded = DOT.split(this.encodedState, 0);
        this.decodedState = decoded[0];
        if (decoded.length > 0) {
            this.clientId = decoded[1];
        }
    }

    private void encode() {
        this.encodedState = this.decodedState + "." + this.clientId;
    }
}

