/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.Arrays;
import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.ImpersonationConstants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.utils.DefaultAuthenticationFlows;
import org.keycloak.models.utils.DefaultRequiredActions;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.UserStorageProviderModel;

public class MigrateTo1_4_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("1.4.0");

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        List realms = session.realms().getRealms();
        for (RealmModel realm : realms) {
            if (realm.getAuthenticationFlows().size() == 0) {
                DefaultAuthenticationFlows.migrateFlows(realm);
                DefaultRequiredActions.addActions(realm);
            }
            ImpersonationConstants.setupImpersonationService(session, realm);
            this.migrateLDAPMappers(session, realm);
            this.migrateUsers(session, realm);
        }
    }

    private void migrateLDAPMappers(KeycloakSession session, RealmModel realm) {
        List<String> mandatoryInLdap = Arrays.asList("username", "username-cn", "first name", "last name");
        for (UserStorageProviderModel providerModel : realm.getUserStorageProviders()) {
            if (!providerModel.getProviderId().equals("ldap")) continue;
            List mappers = realm.getComponents(providerModel.getId());
            for (ComponentModel mapper : mappers) {
                if (!mandatoryInLdap.contains(mapper.getName())) continue;
                mapper = new ComponentModel(mapper);
                mapper.getConfig().putSingle((Object)"is.mandatory.in.ldap", (Object)"true");
                realm.updateComponent(mapper);
            }
        }
    }

    private void migrateUsers(KeycloakSession session, RealmModel realm) {
        List users = session.userLocalStorage().getUsers(realm, false);
        for (UserModel user : users) {
            String email = user.getEmail();
            if ((email = KeycloakModelUtils.toLowerCaseSafe(email)) == null || email.equals(user.getEmail())) continue;
            user.setEmail(email);
            UserCache userCache = session.userCache();
            if (userCache == null) continue;
            userCache.evict(realm, user);
        }
    }
}

