/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentExportRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class StripSecretsUtils {
    public static ComponentRepresentation strip(KeycloakSession session, ComponentRepresentation rep) {
        Map<String, ProviderConfigProperty> configProperties = ComponentUtil.getComponentConfigProperties(session, rep);
        if (rep.getConfig() == null) {
            return rep;
        }
        Iterator itr = rep.getConfig().entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry next = (Map.Entry)itr.next();
            ProviderConfigProperty configProperty = configProperties.get(next.getKey());
            if (configProperty != null) {
                if (!configProperty.isSecret()) continue;
                next.setValue(Collections.singletonList("**********"));
                continue;
            }
            itr.remove();
        }
        return rep;
    }

    public static RealmRepresentation strip(RealmRepresentation rep) {
        if (rep.getSmtpServer() != null && rep.getSmtpServer().containsKey("password")) {
            rep.getSmtpServer().put("password", "**********");
        }
        return rep;
    }

    public static IdentityProviderRepresentation strip(IdentityProviderRepresentation rep) {
        if (rep.getConfig() != null && rep.getConfig().containsKey("clientSecret")) {
            rep.getConfig().put("clientSecret", "**********");
        }
        return rep;
    }

    public static RealmRepresentation stripForExport(KeycloakSession session, RealmRepresentation rep) {
        List users;
        MultivaluedHashMap components;
        List providers;
        StripSecretsUtils.strip(rep);
        List clients = rep.getClients();
        if (clients != null) {
            for (ClientRepresentation c : clients) {
                StripSecretsUtils.strip(c);
            }
        }
        if ((providers = rep.getIdentityProviders()) != null) {
            for (IdentityProviderRepresentation r : providers) {
                StripSecretsUtils.strip(r);
            }
        }
        if ((components = rep.getComponents()) != null) {
            for (Map.Entry ent : components.entrySet()) {
                for (ComponentExportRepresentation c : (List)ent.getValue()) {
                    StripSecretsUtils.strip(session, (String)ent.getKey(), c);
                }
            }
        }
        if ((users = rep.getUsers()) != null) {
            for (UserRepresentation u : users) {
                StripSecretsUtils.strip(u);
            }
        }
        if ((users = rep.getFederatedUsers()) != null) {
            for (UserRepresentation u : users) {
                StripSecretsUtils.strip(u);
            }
        }
        return rep;
    }

    public static UserRepresentation strip(UserRepresentation user) {
        user.setCredentials(null);
        return user;
    }

    public static ClientRepresentation strip(ClientRepresentation rep) {
        if (rep.getSecret() != null) {
            rep.setSecret("**********");
        }
        return rep;
    }

    public static ComponentExportRepresentation strip(KeycloakSession session, String providerType, ComponentExportRepresentation rep) {
        Map<String, ProviderConfigProperty> configProperties = ComponentUtil.getComponentConfigProperties(session, providerType, rep.getProviderId());
        if (rep.getConfig() == null) {
            return rep;
        }
        Iterator itr = rep.getConfig().entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry next = (Map.Entry)itr.next();
            ProviderConfigProperty configProperty = configProperties.get(next.getKey());
            if (configProperty != null) {
                if (!configProperty.isSecret()) continue;
                next.setValue(Collections.singletonList("**********"));
                continue;
            }
            itr.remove();
        }
        MultivaluedHashMap sub = rep.getSubComponents();
        for (Map.Entry ent : sub.entrySet()) {
            for (ComponentExportRepresentation c : (List)ent.getValue()) {
                StripSecretsUtils.strip(session, (String)ent.getKey(), c);
            }
        }
        return rep;
    }
}

