/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.store.syncronization;

import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.store.syncronization.Synchronizer;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderFactory;

public class UserSynchronizer
implements Synchronizer<UserModel.UserRemovedEvent> {
    @Override
    public void synchronize(UserModel.UserRemovedEvent event, KeycloakSessionFactory factory) {
        ProviderFactory providerFactory = factory.getProviderFactory(AuthorizationProvider.class);
        AuthorizationProvider authorizationProvider = (AuthorizationProvider)providerFactory.create(event.getKeycloakSession());
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        UserModel userModel = event.getUser();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        ResourceServerStore resourceServerStore = storeFactory.getResourceServerStore();
        RealmModel realm = event.getRealm();
        realm.getClients().forEach(clientModel -> {
            ResourceServer resourceServer = resourceServerStore.findById(clientModel.getId());
            if (resourceServer != null) {
                resourceStore.findByOwner(userModel.getId(), resourceServer.getId()).forEach(resource -> {
                    String resourceId = resource.getId();
                    policyStore.findByResource(resourceId, resourceServer.getId()).forEach(policy -> {
                        if (policy.getResources().size() == 1) {
                            policyStore.delete(policy.getId());
                        } else {
                            policy.removeResource((Resource)resource);
                        }
                    });
                    resourceStore.delete(resourceId);
                });
            }
        });
    }
}

