/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;

public class ConsoleDisplayMode {
    protected RequiredActionContext requiredActionContext;
    protected AuthenticationFlowContext flowContext;
    protected HeaderBuilder header;

    public static Response browserRequired(KeycloakSession session) {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"X-Text-Form-Challenge browserRequired").type("text/plain").entity((Object)("\n" + ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).getMessage("browserRequired") + "\n")).build();
    }

    public static Response browserContinue(KeycloakSession session, String callback) {
        String browserContinueMsg = ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).getMessage("browserContinue");
        String browserPrompt = ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).getMessage("browserContinuePrompt");
        String answer = ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).getMessage("browserContinueAnswer");
        String header = "X-Text-Form-Challenge callback=\"" + callback + "\"";
        header = header + " browserContinue=\"" + browserPrompt + "\" answer=\"" + answer + "\"";
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)header).type("text/plain").entity((Object)("\n" + browserContinueMsg + "\n")).build();
    }

    public static ConsoleDisplayMode challenge(RequiredActionContext context) {
        return new ConsoleDisplayMode(context);
    }

    public static ConsoleDisplayMode challenge(AuthenticationFlowContext context) {
        return new ConsoleDisplayMode(context);
    }

    public static HeaderBuilder header(RequiredActionContext context) {
        return new ConsoleDisplayMode(context).header();
    }

    public static HeaderBuilder header(AuthenticationFlowContext context) {
        return new ConsoleDisplayMode(context).header();
    }

    ConsoleDisplayMode(RequiredActionContext requiredActionContext) {
        this.requiredActionContext = requiredActionContext;
    }

    ConsoleDisplayMode(AuthenticationFlowContext flowContext) {
        this.flowContext = flowContext;
    }

    public LoginFormsProvider form() {
        if (this.header == null) {
            throw new RuntimeException("Header Not Set");
        }
        return this.formInternal().setStatus(Response.Status.UNAUTHORIZED).setMediaType(MediaType.TEXT_PLAIN_TYPE).setResponseHeader("WWW-Authenticate", this.header.build());
    }

    public Response message(String msg, String ... params) {
        if (this.header == null) {
            throw new RuntimeException("Header Not Set");
        }
        Response response = Response.status((int)401).header("WWW-Authenticate", (Object)this.header.build()).type("text/plain").entity((Object)("\n" + this.formInternal().getMessage(msg, params) + "\n")).build();
        return response;
    }

    public Response text(String text) {
        if (this.header == null) {
            throw new RuntimeException("Header Not Set");
        }
        Response response = Response.status((int)401).header("WWW-Authenticate", (Object)this.header.build()).type("text/plain").entity((Object)("\n" + text + "\n")).build();
        return response;
    }

    public Response response() {
        if (this.header == null) {
            throw new RuntimeException("Header Not Set");
        }
        Response response = Response.status((int)401).header("WWW-Authenticate", (Object)this.header.build()).build();
        return response;
    }

    protected LoginFormsProvider formInternal() {
        if (this.requiredActionContext != null) {
            return this.requiredActionContext.form();
        }
        return this.flowContext.form();
    }

    public HeaderBuilder header() {
        String callback = this.requiredActionContext != null ? this.requiredActionContext.getActionUrl(true).toString() : this.flowContext.getActionUrl(this.flowContext.generateAccessCode(), true).toString();
        this.header = new HeaderBuilder(callback);
        return this.header;
    }

    public class HeaderBuilder {
        protected StringBuilder builder = new StringBuilder();
        protected ParamBuilder param;

        protected HeaderBuilder(String callback) {
            this.builder.append("X-Text-Form-Challenge callback=\"").append(callback).append("\" ");
        }

        protected void checkParam() {
            if (this.param != null) {
                this.param.buildInternal();
                this.param = null;
            }
        }

        public String build() {
            this.checkParam();
            return this.builder.toString();
        }

        public ParamBuilder param(String name) {
            this.checkParam();
            this.builder.append("param=\"").append(name).append("\" ");
            this.param = new ParamBuilder(name);
            return this.param;
        }

        public class ParamBuilder {
            protected boolean mask;
            protected String label;

            protected ParamBuilder(String name) {
                this.label = name;
            }

            public ParamBuilder label(String msg) {
                this.label = ConsoleDisplayMode.this.formInternal().getMessage(msg);
                return this;
            }

            public ParamBuilder labelText(String txt) {
                this.label = txt;
                return this;
            }

            public ParamBuilder mask(boolean mask) {
                this.mask = mask;
                return this;
            }

            public void buildInternal() {
                HeaderBuilder.this.builder.append("label=\"").append(this.label).append(" \" ");
                HeaderBuilder.this.builder.append("mask=").append(this.mask).append(" ");
            }

            public String build() {
                return HeaderBuilder.this.build();
            }

            public ConsoleDisplayMode challenge() {
                return ConsoleDisplayMode.this;
            }

            public LoginFormsProvider form() {
                return ConsoleDisplayMode.this.form();
            }

            public Response message(String msg, String ... params) {
                return ConsoleDisplayMode.this.message(msg, params);
            }

            public Response text(String text) {
                return ConsoleDisplayMode.this.text(text);
            }

            public ParamBuilder param(String name) {
                return HeaderBuilder.this.param(name);
            }
        }
    }
}

