/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.security.Key;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Mac;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;

public class ClientSessionCode {
    private static final byte[] HASH_SEPERATOR = "//".getBytes();
    private final RealmModel realm;
    private final ClientSessionModel clientSession;

    public ClientSessionCode(RealmModel realm, ClientSessionModel clientSession) {
        this.realm = realm;
        this.clientSession = clientSession;
    }

    public static ClientSessionCode parse(String code, KeycloakSession session) {
        try {
            String[] parts = code.split("\\.");
            String id = parts[1];
            ClientSessionModel clientSession = session.sessions().getClientSession(id);
            if (clientSession == null) {
                return null;
            }
            String hash = ClientSessionCode.createHash(clientSession.getRealm(), clientSession);
            if (!hash.equals(parts[0])) {
                return null;
            }
            return new ClientSessionCode(clientSession.getRealm(), clientSession);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static ParseResult parseResult(String code, KeycloakSession session, RealmModel realm) {
        ParseResult result = new ParseResult();
        if (code == null) {
            result.illegalHash = true;
            return result;
        }
        try {
            String[] parts = code.split("\\.");
            String id = parts[1];
            result.clientSession = session.sessions().getClientSession(realm, id);
            if (result.clientSession == null) {
                result.clientSessionNotFound = true;
                return result;
            }
            String hash = ClientSessionCode.createHash(realm, result.clientSession);
            if (!hash.equals(parts[0])) {
                result.illegalHash = true;
                return result;
            }
            result.code = new ClientSessionCode(realm, result.clientSession);
            return result;
        }
        catch (RuntimeException e) {
            result.illegalHash = true;
            return result;
        }
    }

    public static ClientSessionCode parse(String code, KeycloakSession session, RealmModel realm) {
        try {
            String[] parts = code.split("\\.");
            String id = parts[1];
            ClientSessionModel clientSession = session.sessions().getClientSession(realm, id);
            if (clientSession == null) {
                return null;
            }
            String hash = ClientSessionCode.createHash(realm, clientSession);
            if (!hash.equals(parts[0])) {
                return null;
            }
            return new ClientSessionCode(realm, clientSession);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public ClientSessionModel getClientSession() {
        return this.clientSession;
    }

    public boolean isValid(String requestedAction, ActionType actionType) {
        if (!this.isValidAction(requestedAction)) {
            return false;
        }
        return this.isActionActive(actionType);
    }

    public boolean isActionActive(ActionType actionType) {
        int lifespan;
        int timestamp = this.clientSession.getTimestamp();
        switch (actionType) {
            case CLIENT: {
                lifespan = this.realm.getAccessCodeLifespan();
                break;
            }
            case LOGIN: {
                lifespan = this.realm.getAccessCodeLifespanLogin() > 0 ? this.realm.getAccessCodeLifespanLogin() : this.realm.getAccessCodeLifespanUserAction();
                break;
            }
            case USER: {
                lifespan = this.realm.getAccessCodeLifespanUserAction();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return timestamp + lifespan > Time.currentTime();
    }

    public boolean isValidAction(String requestedAction) {
        String action = this.clientSession.getAction();
        if (action == null) {
            return false;
        }
        return action.equals(requestedAction);
    }

    public Set<RoleModel> getRequestedRoles() {
        HashSet<RoleModel> requestedRoles = new HashSet<RoleModel>();
        for (String roleId : this.clientSession.getRoles()) {
            RoleModel role = this.realm.getRoleById(roleId);
            if (role == null) continue;
            requestedRoles.add(role);
        }
        return requestedRoles;
    }

    public Set<ProtocolMapperModel> getRequestedProtocolMappers() {
        HashSet<ProtocolMapperModel> requestedProtocolMappers = new HashSet<ProtocolMapperModel>();
        Set<String> protocolMappers = this.clientSession.getProtocolMappers();
        ClientModel client = this.clientSession.getClient();
        ClientTemplateModel template = client.getClientTemplate();
        if (protocolMappers != null) {
            for (String protocolMapperId : protocolMappers) {
                ProtocolMapperModel protocolMapper = client.getProtocolMapperById(protocolMapperId);
                if (protocolMapper == null && template != null) {
                    protocolMapper = template.getProtocolMapperById(protocolMapperId);
                }
                if (protocolMapper == null) continue;
                requestedProtocolMappers.add(protocolMapper);
            }
        }
        return requestedProtocolMappers;
    }

    public void setAction(String action) {
        this.clientSession.setAction(action);
        this.clientSession.setTimestamp(Time.currentTime());
    }

    public String getCode() {
        return ClientSessionCode.generateCode(this.realm, this.clientSession);
    }

    private static String generateCode(RealmModel realm, ClientSessionModel clientSession) {
        String hash = ClientSessionCode.createHash(realm, clientSession);
        StringBuilder sb = new StringBuilder();
        sb.append(hash);
        sb.append(".");
        sb.append(clientSession.getId());
        return sb.toString();
    }

    private static String createHash(RealmModel realm, ClientSessionModel clientSession) {
        try {
            Key codeSecretKey = realm.getCodeSecretKey();
            Mac mac = Mac.getInstance(codeSecretKey.getAlgorithm());
            mac.init(codeSecretKey);
            mac.update(clientSession.getId().getBytes());
            mac.update(HASH_SEPERATOR);
            mac.update(clientSession.getNote("action_key").getBytes());
            return Base64Url.encode((byte[])mac.doFinal());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ParseResult {
        ClientSessionCode code;
        boolean clientSessionNotFound;
        boolean illegalHash;
        ClientSessionModel clientSession;

        public ClientSessionCode getCode() {
            return this.code;
        }

        public boolean isClientSessionNotFound() {
            return this.clientSessionNotFound;
        }

        public boolean isIllegalHash() {
            return this.illegalHash;
        }

        public ClientSessionModel getClientSession() {
            return this.clientSession;
        }
    }

    public static enum ActionType {
        CLIENT,
        LOGIN,
        USER;

    }
}

