/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.provider.Provider;
import org.keycloak.storage.group.GroupLookupProvider;

public interface GroupProvider
extends Provider,
GroupLookupProvider {
    default public GroupModel getGroupById(String id, RealmModel realm) {
        return this.getGroupById(realm, id);
    }

    @Deprecated
    default public List<GroupModel> getGroups(RealmModel realm) {
        return this.getGroupsStream(realm).collect(Collectors.toList());
    }

    public Stream<GroupModel> getGroupsStream(RealmModel var1);

    default public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids) {
        return this.getGroupsStream(realm, ids, null, null, null);
    }

    public Stream<GroupModel> getGroupsStream(RealmModel var1, Stream<String> var2, String var3, Integer var4, Integer var5);

    default public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids, Integer first, Integer max) {
        return this.getGroupsStream(realm, ids, null, first, max);
    }

    default public Long getGroupsCount(RealmModel realm, Stream<String> ids, String search) {
        return this.getGroupsStream(realm, ids, search, null, null).count();
    }

    public Long getGroupsCount(RealmModel var1, Boolean var2);

    public Long getGroupsCountByNameContaining(RealmModel var1, String var2);

    @Deprecated
    default public List<GroupModel> getGroupsByRole(RealmModel realm, RoleModel role, int firstResult, int maxResults) {
        return this.getGroupsByRoleStream(realm, role, firstResult, maxResults).collect(Collectors.toList());
    }

    public Stream<GroupModel> getGroupsByRoleStream(RealmModel var1, RoleModel var2, Integer var3, Integer var4);

    @Deprecated
    default public List<GroupModel> getTopLevelGroups(RealmModel realm) {
        return this.getTopLevelGroupsStream(realm).collect(Collectors.toList());
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel var1);

    @Deprecated
    default public List<GroupModel> getTopLevelGroups(RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.getTopLevelGroupsStream(realm, firstResult, maxResults).collect(Collectors.toList());
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel var1, Integer var2, Integer var3);

    default public GroupModel createGroup(RealmModel realm, String name) {
        return this.createGroup(realm, null, name, null);
    }

    default public GroupModel createGroup(RealmModel realm, String id, String name) {
        return this.createGroup(realm, id, name, null);
    }

    default public GroupModel createGroup(RealmModel realm, String name, GroupModel toParent) {
        return this.createGroup(realm, null, name, toParent);
    }

    public GroupModel createGroup(RealmModel var1, String var2, String var3, GroupModel var4);

    public boolean removeGroup(RealmModel var1, GroupModel var2);

    public void moveGroup(RealmModel var1, GroupModel var2, GroupModel var3);

    public void addTopLevelGroup(RealmModel var1, GroupModel var2);

    public void preRemove(RealmModel var1, RoleModel var2);
}

