/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.store;

import java.util.HashMap;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.store.syncronization.ClientApplicationSynchronizer;
import org.keycloak.authorization.store.syncronization.RealmSynchronizer;
import org.keycloak.authorization.store.syncronization.Synchronizer;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderFactory;

public interface AuthorizationStoreFactory
extends ProviderFactory<StoreFactory> {
    @Override
    default public void postInit(KeycloakSessionFactory factory) {
        this.registerSynchronizationListeners(factory);
    }

    default public void registerSynchronizationListeners(KeycloakSessionFactory factory) {
        HashMap<Class, Synchronizer<RealmModel.ClientRemovedEvent>> synchronizers = new HashMap<Class, Synchronizer<RealmModel.ClientRemovedEvent>>();
        synchronizers.put(RealmModel.ClientRemovedEvent.class, new ClientApplicationSynchronizer());
        synchronizers.put(RealmModel.RealmRemovedEvent.class, new RealmSynchronizer());
        factory.register(event -> {
            try {
                synchronizers.forEach((eventType, synchronizer) -> {
                    if (eventType.isInstance(event)) {
                        synchronizer.synchronize(event, factory);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException("Error synchronizing authorization data.", e);
            }
        });
    }
}

