/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.adapter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.DefaultRoles;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.federated.UserFederatedStorageProvider;

public abstract class AbstractUserAdapterFederatedStorage
implements UserModel {
    public static String FIRST_NAME_ATTRIBUTE = "FIRST_NAME";
    public static String LAST_NAME_ATTRIBUTE = "LAST_NAME";
    public static String EMAIL_ATTRIBUTE = "EMAIL";
    public static String EMAIL_VERIFIED_ATTRIBUTE = "EMAIL_VERIFIED";
    public static String CREATED_TIMESTAMP_ATTRIBUTE = "CREATED_TIMESTAMP";
    public static String ENABLED_ATTRIBUTE = "ENABLED";
    public static String OTP_ENABLED_ATTRIBUTE = "OTP_ENABLED";
    protected KeycloakSession session;
    protected RealmModel realm;
    protected ComponentModel storageProviderModel;
    protected StorageId storageId;

    public AbstractUserAdapterFederatedStorage(KeycloakSession session, RealmModel realm, ComponentModel storageProviderModel) {
        this.session = session;
        this.realm = realm;
        this.storageProviderModel = storageProviderModel;
    }

    public UserFederatedStorageProvider getFederatedStorage() {
        return this.session.userFederatedStorage();
    }

    @Override
    public Set<String> getRequiredActions() {
        return this.getFederatedStorage().getRequiredActions(this.realm, this);
    }

    @Override
    public void addRequiredAction(String action) {
        this.getFederatedStorage().addRequiredAction(this.realm, this, action);
    }

    @Override
    public void removeRequiredAction(String action) {
        this.getFederatedStorage().removeRequiredAction(this.realm, this, action);
    }

    @Override
    public void addRequiredAction(UserModel.RequiredAction action) {
        this.getFederatedStorage().addRequiredAction(this.realm, this, action.name());
    }

    @Override
    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.getFederatedStorage().removeRequiredAction(this.realm, this, action.name());
    }

    protected Set<GroupModel> getGroupsInternal() {
        return Collections.EMPTY_SET;
    }

    protected boolean appendDefaultGroups() {
        return true;
    }

    @Override
    public Set<GroupModel> getGroups() {
        HashSet<GroupModel> set = new HashSet<GroupModel>();
        set.addAll(this.getFederatedStorage().getGroups(this.realm, this));
        if (this.appendDefaultGroups()) {
            set.addAll(this.realm.getDefaultGroups());
        }
        set.addAll(this.getGroupsInternal());
        return set;
    }

    @Override
    public void joinGroup(GroupModel group) {
        this.getFederatedStorage().joinGroup(this.realm, this, group);
    }

    @Override
    public void leaveGroup(GroupModel group) {
        this.getFederatedStorage().leaveGroup(this.realm, this, group);
    }

    @Override
    public boolean isMemberOf(GroupModel group) {
        Set<GroupModel> roles = this.getGroups();
        return KeycloakModelUtils.isMember(roles, group);
    }

    @Override
    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    @Override
    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            ClientModel appModel;
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof ClientModel) || !(appModel = (ClientModel)container).getId().equals(app.getId())) continue;
            roles.add(role);
        }
        return roles;
    }

    @Override
    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        return KeycloakModelUtils.hasRole(roles, role);
    }

    @Override
    public void grantRole(RoleModel role) {
        this.getFederatedStorage().grantRole(this.realm, this, role);
    }

    protected boolean appendDefaultRolesToRoleMappings() {
        return true;
    }

    protected Set<RoleModel> getRoleMappingsInternal() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<RoleModel> getRoleMappings() {
        HashSet<RoleModel> set = new HashSet<RoleModel>();
        set.addAll(this.getFederatedRoleMappings());
        if (this.appendDefaultRolesToRoleMappings()) {
            set.addAll(DefaultRoles.getDefaultRoles(this.realm));
        }
        set.addAll(this.getRoleMappingsInternal());
        return set;
    }

    protected Set<RoleModel> getFederatedRoleMappings() {
        return this.getFederatedStorage().getRoleMappings(this.realm, this);
    }

    @Override
    public void deleteRoleMapping(RoleModel role) {
        this.getFederatedStorage().deleteRoleMapping(this.realm, this, role);
    }

    @Override
    public boolean isEnabled() {
        String val = this.getFirstAttribute(ENABLED_ATTRIBUTE);
        if (val == null) {
            return true;
        }
        return Boolean.valueOf(val);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setSingleAttribute(ENABLED_ATTRIBUTE, Boolean.toString(enabled));
    }

    @Override
    public boolean isOtpEnabled() {
        String val = this.getFirstAttribute(OTP_ENABLED_ATTRIBUTE);
        if (val == null) {
            return false;
        }
        return Boolean.valueOf(val);
    }

    @Override
    public void setOtpEnabled(boolean totp) {
        this.setSingleAttribute(OTP_ENABLED_ATTRIBUTE, Boolean.toString(totp));
    }

    @Override
    public String getFederationLink() {
        return null;
    }

    @Override
    public void setFederationLink(String link) {
    }

    @Override
    public String getServiceAccountClientLink() {
        return null;
    }

    @Override
    public void setServiceAccountClientLink(String clientInternalId) {
    }

    @Override
    public String getId() {
        if (this.storageId == null) {
            this.storageId = new StorageId(this.storageProviderModel.getId(), this.getUsername());
        }
        return this.storageId.getId();
    }

    @Override
    public Long getCreatedTimestamp() {
        String val = this.getFirstAttribute(CREATED_TIMESTAMP_ATTRIBUTE);
        if (val == null) {
            return null;
        }
        return Long.valueOf(val);
    }

    @Override
    public void setCreatedTimestamp(Long timestamp) {
        if (timestamp == null) {
            this.setSingleAttribute(CREATED_TIMESTAMP_ATTRIBUTE, null);
        } else {
            this.setSingleAttribute(CREATED_TIMESTAMP_ATTRIBUTE, Long.toString(timestamp));
        }
    }

    @Override
    public void setSingleAttribute(String name, String value) {
        this.getFederatedStorage().setSingleAttribute(this.realm, this, name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.getFederatedStorage().removeAttribute(this.realm, this, name);
    }

    @Override
    public void setAttribute(String name, List<String> values) {
        this.getFederatedStorage().setAttribute(this.realm, this, name, values);
    }

    @Override
    public String getFirstAttribute(String name) {
        return (String)this.getFederatedStorage().getAttributes(this.realm, this).getFirst((Object)name);
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.getFederatedStorage().getAttributes(this.realm, this);
    }

    @Override
    public List<String> getAttribute(String name) {
        return (List)this.getFederatedStorage().getAttributes(this.realm, this).get((Object)name);
    }

    @Override
    public String getFirstName() {
        return this.getFirstAttribute(FIRST_NAME_ATTRIBUTE);
    }

    @Override
    public void setFirstName(String firstName) {
        this.setSingleAttribute(FIRST_NAME_ATTRIBUTE, firstName);
    }

    @Override
    public String getLastName() {
        return this.getFirstAttribute(LAST_NAME_ATTRIBUTE);
    }

    @Override
    public void setLastName(String lastName) {
        this.setSingleAttribute(LAST_NAME_ATTRIBUTE, lastName);
    }

    @Override
    public String getEmail() {
        return this.getFirstAttribute(EMAIL_ATTRIBUTE);
    }

    @Override
    public void setEmail(String email) {
        this.setSingleAttribute(EMAIL_ATTRIBUTE, email);
    }

    @Override
    public boolean isEmailVerified() {
        String val = this.getFirstAttribute(EMAIL_VERIFIED_ATTRIBUTE);
        if (val == null) {
            return false;
        }
        return Boolean.valueOf(val);
    }

    @Override
    public void setEmailVerified(boolean verified) {
        this.setSingleAttribute(EMAIL_VERIFIED_ATTRIBUTE, Boolean.toString(verified));
    }

    @Override
    public void updateCredential(UserCredentialModel cred) {
        this.getFederatedStorage().updateCredential(this.realm, (UserModel)this, cred);
    }

    @Override
    public List<UserCredentialValueModel> getCredentialsDirectly() {
        return this.getFederatedStorage().getCredentials(this.realm, this);
    }

    @Override
    public void updateCredentialDirectly(UserCredentialValueModel cred) {
        this.getFederatedStorage().updateCredential(this.realm, (UserModel)this, cred);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

