/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import org.keycloak.models.KeycloakContext;
import org.keycloak.models.UserModel;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PolicyError;

public class LengthPasswordPolicyProvider
implements PasswordPolicyProvider {
    private static final String ERROR_MESSAGE = "invalidPasswordMinLengthMessage";
    private KeycloakContext context;

    public LengthPasswordPolicyProvider(KeycloakContext context) {
        this.context = context;
    }

    @Override
    public PolicyError validate(String username, String password) {
        int min = (Integer)this.context.getRealm().getPasswordPolicy().getPolicyConfig("length");
        return password.length() < min ? new PolicyError(ERROR_MESSAGE, min) : null;
    }

    @Override
    public PolicyError validate(UserModel user, String password) {
        return this.validate(user.getUsername(), password);
    }

    @Override
    public Object parseConfig(String value) {
        return value != null ? Integer.parseInt(value) : 8;
    }

    @Override
    public void close() {
    }
}

