/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.changeset;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.changeset.UserData;

public class UserDataAdapter
implements UserModel {
    protected UserData userData;
    protected RealmModel realm;
    protected KeycloakSession session;
    protected Set<String> managedCredentialTypes;
    protected List<UserCredentialModel> updatedManagedCredentials = new LinkedList<UserCredentialModel>();

    public UserDataAdapter(KeycloakSession session, RealmModel realm, UserData userData) {
        this.session = session;
        this.realm = realm;
        this.userData = userData;
        this.userData.rememberState();
    }

    @Override
    public String getId() {
        return this.userData.getId();
    }

    @Override
    public String getUsername() {
        return this.userData.getUsername();
    }

    @Override
    public void setUsername(String username) {
        this.userData.setUsername(username);
    }

    @Override
    public Long getCreatedTimestamp() {
        return this.userData.getCreatedTimestamp();
    }

    @Override
    public void setCreatedTimestamp(Long timestamp) {
        this.userData.setCreatedTimestamp(timestamp);
    }

    @Override
    public boolean isEnabled() {
        return this.userData.isEnabled();
    }

    @Override
    public boolean isOtpEnabled() {
        return this.userData.isTotp();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.userData.setEnabled(enabled);
    }

    @Override
    public void setSingleAttribute(String name, String value) {
        this.userData.setSingleAttribute(name, value);
    }

    @Override
    public void setAttribute(String name, List<String> values) {
        this.userData.setAttribute(name, values);
    }

    @Override
    public void removeAttribute(String name) {
        this.userData.removeAttribute(name);
    }

    @Override
    public String getFirstAttribute(String name) {
        return (String)this.userData.getAttributes().getFirst((Object)name);
    }

    @Override
    public List<String> getAttribute(String name) {
        return (List)this.userData.getAttributes().get((Object)name);
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.userData.getAttributes();
    }

    @Override
    public Set<String> getRequiredActions() {
        return this.userData.getRequiredActions();
    }

    @Override
    public void addRequiredAction(String action) {
        this.userData.addRequiredAction(action);
    }

    @Override
    public void removeRequiredAction(String action) {
        this.userData.removeRequiredAction(action);
    }

    @Override
    public void addRequiredAction(UserModel.RequiredAction action) {
        this.userData.addRequiredAction(action.name());
    }

    @Override
    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.userData.removeRequiredAction(action.name());
    }

    @Override
    public String getFirstName() {
        return this.userData.getFirstName();
    }

    @Override
    public void setFirstName(String firstName) {
        this.userData.setFirstName(firstName);
    }

    @Override
    public String getLastName() {
        return this.userData.getLastName();
    }

    @Override
    public void setLastName(String lastName) {
        this.userData.setLastName(lastName);
    }

    @Override
    public String getEmail() {
        return this.userData.getEmail();
    }

    @Override
    public void setEmail(String email) {
        this.userData.setEmail(email);
    }

    @Override
    public boolean isEmailVerified() {
        return this.userData.isEmailVerified();
    }

    @Override
    public void setEmailVerified(boolean verified) {
        this.userData.setEmailVerified(verified);
    }

    @Override
    public void setOtpEnabled(boolean totp) {
        this.userData.setTotp(totp);
    }

    @Override
    public void updateCredential(UserCredentialModel cred) {
    }

    @Override
    public List<UserCredentialValueModel> getCredentialsDirectly() {
        return null;
    }

    @Override
    public void updateCredentialDirectly(UserCredentialValueModel cred) {
    }

    @Override
    public Set<GroupModel> getGroups() {
        Set<String> groups = this.userData.getGroupIds();
        HashSet<GroupModel> set = new HashSet<GroupModel>();
        for (String id : groups) {
            GroupModel group = this.realm.getGroupById(id);
            if (group == null) continue;
            set.add(group);
        }
        return set;
    }

    @Override
    public void joinGroup(GroupModel group) {
        this.userData.joinGroup(group.getId());
    }

    @Override
    public void leaveGroup(GroupModel group) {
        this.userData.leaveGroup(group.getId());
    }

    @Override
    public boolean isMemberOf(GroupModel group) {
        Set<GroupModel> roles = this.getGroups();
        return KeycloakModelUtils.isMember(roles, group);
    }

    @Override
    public String getFederationLink() {
        return null;
    }

    @Override
    public void setFederationLink(String link) {
    }

    @Override
    public String getServiceAccountClientLink() {
        return null;
    }

    @Override
    public void setServiceAccountClientLink(String clientInternalId) {
    }

    @Override
    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    @Override
    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            ClientModel appModel;
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof ClientModel) || !(appModel = (ClientModel)container).getId().equals(app.getId())) continue;
            roles.add(role);
        }
        return roles;
    }

    @Override
    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        return KeycloakModelUtils.hasRole(roles, role);
    }

    @Override
    public void grantRole(RoleModel role) {
        this.userData.grantRole(role.getId());
    }

    @Override
    public Set<RoleModel> getRoleMappings() {
        Set<String> roles = this.userData.getRoleMappings();
        HashSet<RoleModel> set = new HashSet<RoleModel>();
        for (String id : roles) {
            RoleModel role = this.realm.getRoleById(id);
            if (role == null) continue;
            set.add(role);
        }
        return set;
    }

    @Override
    public void deleteRoleMapping(RoleModel role) {
        this.userData.deleteRoleMapping(role.getId());
    }
}

