/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.List;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.ClientModel;
import org.keycloak.models.Constants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MigrateTo1_2_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("1.2.0");

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    public void setupBrokerService(RealmModel realm) {
        ClientModel client = realm.getClientByClientId("broker");
        if (client == null) {
            client = KeycloakModelUtils.createClient(realm, "broker");
            client.setEnabled(true);
            client.setName("${client_broker}");
            client.setFullScopeAllowed(false);
            for (String role : Constants.BROKER_SERVICE_ROLES) {
                RoleModel roleModel = client.addRole(role);
                roleModel.setDescription("${role_" + role.toLowerCase().replaceAll("_", "-") + "}");
                roleModel.setScopeParamRequired(false);
            }
        }
    }

    private void setupClientNames(RealmModel realm) {
        this.setupClientName(realm.getClientByClientId("account"));
        this.setupClientName(realm.getClientByClientId("security-admin-console"));
        this.setupClientName(realm.getClientByClientId("realm-management"));
    }

    private void setupClientName(ClientModel client) {
        if (client != null && client.getName() == null) {
            client.setName("${client_" + client.getClientId() + "}");
        }
    }

    @Override
    public void migrate(KeycloakSession session) {
        List<RealmModel> realms = session.realms().getRealms();
        for (RealmModel realm : realms) {
            this.setupBrokerService(realm);
            this.setupClientNames(realm);
        }
    }
}

