/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.UUID;
import org.keycloak.credential.CredentialInput;

public class UserCredentialModel
implements CredentialInput {
    public static final String PASSWORD = "password";
    public static final String PASSWORD_HISTORY = "password-history";
    public static final String PASSWORD_TOKEN = "password-token";
    public static final String SECRET = "secret";
    public static final String TOTP = "totp";
    public static final String HOTP = "hotp";
    public static final String CLIENT_CERT = "cert";
    public static final String KERBEROS = "kerberos";
    protected String type;
    protected String value;
    protected String device;
    protected String algorithm;

    public static UserCredentialModel password(String password) {
        UserCredentialModel model = new UserCredentialModel();
        model.setType(PASSWORD);
        model.setValue(password);
        return model;
    }

    public static UserCredentialModel passwordToken(String passwordToken) {
        UserCredentialModel model = new UserCredentialModel();
        model.setType(PASSWORD_TOKEN);
        model.setValue(passwordToken);
        return model;
    }

    public static UserCredentialModel secret(String password) {
        UserCredentialModel model = new UserCredentialModel();
        model.setType(SECRET);
        model.setValue(password);
        return model;
    }

    public static UserCredentialModel otp(String type, String key) {
        if (type.equals(HOTP)) {
            return UserCredentialModel.hotp(key);
        }
        if (type.equals(TOTP)) {
            return UserCredentialModel.totp(key);
        }
        throw new RuntimeException("Unknown OTP type");
    }

    public static UserCredentialModel totp(String key) {
        UserCredentialModel model = new UserCredentialModel();
        model.setType(TOTP);
        model.setValue(key);
        return model;
    }

    public static UserCredentialModel hotp(String key) {
        UserCredentialModel model = new UserCredentialModel();
        model.setType(HOTP);
        model.setValue(key);
        return model;
    }

    public static UserCredentialModel kerberos(String token) {
        UserCredentialModel model = new UserCredentialModel();
        model.setType(KERBEROS);
        model.setValue(token);
        return model;
    }

    public static UserCredentialModel generateSecret() {
        UserCredentialModel model = new UserCredentialModel();
        model.setType(SECRET);
        model.setValue(UUID.randomUUID().toString());
        return model;
    }

    public static boolean isOtp(String type) {
        return TOTP.equals(type) || HOTP.equals(type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }
}

