/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.UserModel;
import org.keycloak.policy.PasswordPolicyManagerProvider;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PolicyError;

public class DefaultPasswordPolicyManagerProvider
implements PasswordPolicyManagerProvider {
    private KeycloakSession session;

    public DefaultPasswordPolicyManagerProvider(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public PolicyError validate(UserModel user, String password) {
        for (PasswordPolicyProvider p : this.getProviders(this.session)) {
            PolicyError policyError = p.validate(user, password);
            if (policyError == null) continue;
            return policyError;
        }
        return null;
    }

    @Override
    public PolicyError validate(String user, String password) {
        for (PasswordPolicyProvider p : this.getProviders(this.session)) {
            PolicyError policyError = p.validate(user, password);
            if (policyError == null) continue;
            return policyError;
        }
        return null;
    }

    @Override
    public void close() {
    }

    private List<PasswordPolicyProvider> getProviders(KeycloakSession session) {
        LinkedList<PasswordPolicyProvider> list = new LinkedList<PasswordPolicyProvider>();
        PasswordPolicy policy = session.getContext().getRealm().getPasswordPolicy();
        for (String id : policy.getPolicies()) {
            PasswordPolicyProvider provider = session.getProvider(PasswordPolicyProvider.class, id);
            list.add(provider);
        }
        return list;
    }
}

