/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.keycloak.hash.PasswordHashManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.policy.HistoryPasswordPolicyProviderFactory;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PolicyError;

public class HistoryPasswordPolicyProvider
implements PasswordPolicyProvider {
    private static final String ERROR_MESSAGE = "invalidPasswordHistoryMessage";
    private KeycloakSession session;

    public HistoryPasswordPolicyProvider(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public PolicyError validate(String username, String password) {
        return null;
    }

    @Override
    public PolicyError validate(UserModel user, String password) {
        PasswordPolicy policy = this.session.getContext().getRealm().getPasswordPolicy();
        int passwordHistoryPolicyValue = (Integer)policy.getPolicyConfig("passwordHistory");
        if (passwordHistoryPolicyValue != -1) {
            UserCredentialValueModel cred = this.getCredentialValueModel(user, "password");
            if (cred != null && PasswordHashManager.verify(this.session, policy, password, cred)) {
                return new PolicyError(ERROR_MESSAGE, passwordHistoryPolicyValue);
            }
            List<UserCredentialValueModel> passwordExpiredCredentials = this.getCredentialValueModels(user, passwordHistoryPolicyValue - 1, "password-history");
            for (UserCredentialValueModel credential : passwordExpiredCredentials) {
                if (!PasswordHashManager.verify(this.session, policy, password, credential)) continue;
                return new PolicyError(ERROR_MESSAGE, passwordHistoryPolicyValue);
            }
        }
        return null;
    }

    private UserCredentialValueModel getCredentialValueModel(UserModel user, String credType) {
        for (UserCredentialValueModel model : user.getCredentialsDirectly()) {
            if (!model.getType().equals(credType)) continue;
            return model;
        }
        return null;
    }

    private List<UserCredentialValueModel> getCredentialValueModels(UserModel user, int expiredPasswordsPolicyValue, String credType) {
        ArrayList<UserCredentialValueModel> credentialModels = new ArrayList<UserCredentialValueModel>();
        for (UserCredentialValueModel model : user.getCredentialsDirectly()) {
            if (!model.getType().equals(credType)) continue;
            credentialModels.add(model);
        }
        Collections.sort(credentialModels, new Comparator<UserCredentialValueModel>(){

            @Override
            public int compare(UserCredentialValueModel credFirst, UserCredentialValueModel credSecond) {
                if (credFirst.getCreatedDate() > credSecond.getCreatedDate()) {
                    return -1;
                }
                if (credFirst.getCreatedDate() < credSecond.getCreatedDate()) {
                    return 1;
                }
                return 0;
            }
        });
        if (credentialModels.size() > expiredPasswordsPolicyValue) {
            return credentialModels.subList(0, expiredPasswordsPolicyValue);
        }
        return credentialModels;
    }

    @Override
    public Object parseConfig(String value) {
        return value != null ? Integer.parseInt(value) : HistoryPasswordPolicyProviderFactory.DEFAULT_VALUE;
    }

    @Override
    public void close() {
    }
}

