/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderFactory;

public class ComponentUtil {
    public static Map<String, ProviderConfigProperty> getComponentConfigProperties(KeycloakSession session, ComponentModel component) {
        try {
            List<ProviderConfigProperty> l = ComponentUtil.getComponentFactory(session, component).getConfigProperties();
            HashMap<String, ProviderConfigProperty> properties = new HashMap<String, ProviderConfigProperty>();
            for (ProviderConfigProperty p : l) {
                properties.put(p.getName(), p);
            }
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ComponentFactory getComponentFactory(KeycloakSession session, ComponentModel component) {
        Class<? extends Provider> provider = session.getProviderClass(component.getProviderType());
        if (provider == null) {
            throw new RuntimeException("Invalid provider type '" + component.getProviderType() + "'");
        }
        ProviderFactory<? extends Provider> f = session.getKeycloakSessionFactory().getProviderFactory(provider, component.getProviderId());
        if (f == null) {
            throw new RuntimeException("No such provider '" + component.getProviderId() + "'");
        }
        ComponentFactory cf = (ComponentFactory)f;
        return cf;
    }
}

