/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.session.UserSessionPersisterProvider;

public class UserManager {
    private KeycloakSession session;

    public UserManager(KeycloakSession session) {
        this.session = session;
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        return this.removeUser(realm, user, this.session.users());
    }

    public boolean removeUser(RealmModel realm, UserModel user, UserProvider userProvider) {
        UserSessionPersisterProvider sessionsPersister;
        UserSessionProvider sessions = this.session.sessions();
        if (sessions != null) {
            sessions.onUserRemoved(realm, user);
        }
        if ((sessionsPersister = this.session.getProvider(UserSessionPersisterProvider.class)) != null) {
            sessionsPersister.onUserRemoved(realm, user);
        }
        return userProvider.removeUser(realm, user);
    }
}

