/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Comparator;

public interface OrderedModel {
    public String getGuiOrder();

    public static class OrderedModelComparator<OM extends OrderedModel>
    implements Comparator<OM> {
        @Override
        public int compare(OM o1, OM o2) {
            int o1order = this.parseOrder(o1);
            int o2order = this.parseOrder(o2);
            return o1order - o2order;
        }

        private int parseOrder(OM model) {
            if (model != null && model.getGuiOrder() != null) {
                try {
                    return Integer.parseInt(model.getGuiOrder());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 10000;
        }
    }
}

