/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.servlet;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.HttpClient;
import org.keycloak.AbstractOAuthClient;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.adapters.TokenGrantRequest;
import org.keycloak.util.KeycloakUriBuilder;

public class ServletOAuthClient
extends AbstractOAuthClient {
    protected HttpClient client;

    public void start() {
        if (this.client == null) {
            this.client = new HttpClientBuilder().trustStore(this.truststore).hostnameVerification(HttpClientBuilder.HostnameVerificationPolicy.ANY).connectionPoolSize(10).build();
        }
    }

    public void stop() {
        this.client.getConnectionManager().shutdown();
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public String resolveBearerToken(String redirectUri, String code) throws IOException, TokenGrantRequest.HttpFailure {
        return TokenGrantRequest.invoke((HttpClient)this.client, (String)code, (String)this.codeUrl, (String)redirectUri, (String)this.clientId, (Map)this.credentials).getToken();
    }

    public void redirectRelative(String relativePath, HttpServletRequest request, HttpServletResponse response) throws IOException {
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromUri((String)request.getRequestURL().toString()).replacePath(request.getContextPath()).replaceQuery(null).path(relativePath);
        String redirect = builder.toTemplate();
        this.redirect(redirect, request, response);
    }

    public void redirect(String redirectUri, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String state = this.getStateCode();
        KeycloakUriBuilder uriBuilder = KeycloakUriBuilder.fromUri((String)this.authUrl).queryParam("client_id", new Object[]{this.clientId}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("state", new Object[]{state});
        if (this.scope != null) {
            uriBuilder.queryParam("scope", new Object[]{this.scope});
        }
        URI url = uriBuilder.build(new Object[0]);
        String stateCookiePath = this.stateCookiePath;
        if (stateCookiePath == null) {
            stateCookiePath = request.getContextPath();
        }
        if (stateCookiePath.equals("")) {
            stateCookiePath = "/";
        }
        Cookie cookie = new Cookie(this.stateCookieName, state);
        cookie.setSecure(this.isSecure);
        cookie.setPath(stateCookiePath);
        response.addCookie(cookie);
        response.sendRedirect(url.toString());
    }

    protected String getCookieValue(String name, HttpServletRequest request) {
        if (request.getCookies() == null) {
            return null;
        }
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    protected String getCode(HttpServletRequest request) {
        String[] params;
        String query = request.getQueryString();
        if (query == null) {
            return null;
        }
        for (String param : params = query.split("&")) {
            String name;
            int eq = param.indexOf(61);
            if (eq == -1 || !(name = param.substring(0, eq)).equals("code")) continue;
            return param.substring(eq + 1);
        }
        return null;
    }

    public String getBearerToken(HttpServletRequest request) throws IOException, TokenGrantRequest.HttpFailure {
        String error = request.getParameter("error");
        if (error != null) {
            throw new IOException("OAuth error: " + error);
        }
        String redirectUri = request.getRequestURL().append("?").append(request.getQueryString()).toString();
        String stateCookie = this.getCookieValue(this.stateCookieName, request);
        if (stateCookie == null) {
            throw new IOException("state cookie not set");
        }
        String state = request.getParameter("state");
        String code = request.getParameter("code");
        if (state == null) {
            throw new IOException("state parameter was null");
        }
        if (!state.equals(stateCookie)) {
            throw new IOException("state parameter invalid");
        }
        if (code == null) {
            throw new IOException("code parameter was null");
        }
        return this.resolveBearerToken(redirectUri, code);
    }
}

