/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.servlet;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.HttpClient;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.servlet.ServletOAuthClient;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.KeycloakUriBuilder;

public class ServletOAuthClientBuilder {
    public static ServletOAuthClient build(InputStream is) {
        AdapterConfig adapterConfig = ServletOAuthClientBuilder.getAdapterConfig(is);
        return ServletOAuthClientBuilder.build(adapterConfig);
    }

    private static AdapterConfig getAdapterConfig(InputStream is) {
        try {
            return (AdapterConfig)JsonSerialization.readValue((InputStream)is, AdapterConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ServletOAuthClient build(AdapterConfig adapterConfig) {
        ServletOAuthClient oauthClient = new ServletOAuthClient();
        ServletOAuthClientBuilder.build(adapterConfig, oauthClient);
        return oauthClient;
    }

    public static void build(InputStream is, ServletOAuthClient oauthClient) {
        ServletOAuthClientBuilder.build(ServletOAuthClientBuilder.getAdapterConfig(is), oauthClient);
    }

    public static void build(AdapterConfig adapterConfig, ServletOAuthClient oauthClient) {
        HttpClient client = new HttpClientBuilder().build(adapterConfig);
        oauthClient.setClient(client);
        oauthClient.setClientId(adapterConfig.getResource());
        oauthClient.setPublicClient(adapterConfig.isPublicClient());
        oauthClient.setCredentials(adapterConfig.getCredentials());
        if (adapterConfig.getAuthServerUrl() == null) {
            throw new RuntimeException("You must specify auth-url");
        }
        KeycloakUriBuilder serverBuilder = KeycloakUriBuilder.fromUri((String)adapterConfig.getAuthServerUrl());
        String authUrl = serverBuilder.clone().path("/realms/{realm-name}/tokens/login").build(new Object[]{adapterConfig.getRealm()}).toString();
        String tokenUrl = serverBuilder.clone().path("/realms/{realm-name}/tokens/access/codes").build(new Object[]{adapterConfig.getRealm()}).toString();
        String refreshUrl = serverBuilder.clone().path("/realms/{realm-name}/tokens/refresh").build(new Object[]{adapterConfig.getRealm()}).toString();
        oauthClient.setAuthUrl(authUrl);
        oauthClient.setCodeUrl(tokenUrl);
        oauthClient.setRefreshUrl(refreshUrl);
    }
}

