/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.authentication;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.springsecurity.AdapterDeploymentContextBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

public class KeycloakLogoutHandler
implements LogoutHandler {
    public static final String SSO_LOGOUT_COMPLETE_PARAM = "sso_complete";
    private static final Logger log = LoggerFactory.getLogger(KeycloakLogoutHandler.class);
    private AdapterDeploymentContextBean deploymentContextBean;

    public KeycloakLogoutHandler(AdapterDeploymentContextBean deploymentContextBean) {
        Assert.notNull((Object)deploymentContextBean);
        this.deploymentContextBean = deploymentContextBean;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        if (authentication instanceof AnonymousAuthenticationToken) {
            log.warn("Attempt to log out an anonymous authentication");
            return;
        }
        if (Boolean.valueOf(request.getParameter(SSO_LOGOUT_COMPLETE_PARAM)).booleanValue()) {
            return;
        }
        try {
            this.handleSingleSignOut(request, response);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to redirect to SSO url!", e);
        }
    }

    protected String createRedirectUrl(HttpServletRequest request) {
        return UriComponentsBuilder.fromHttpUrl((String)request.getRequestURL().toString()).replaceQueryParam(SSO_LOGOUT_COMPLETE_PARAM, new Object[]{true}).build().toUriString();
    }

    protected void handleSingleSignOut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        KeycloakDeployment deployment = this.deploymentContextBean.getDeployment();
        String redirectUrl = this.createRedirectUrl(request);
        response.sendRedirect(deployment.getLogoutUrl().queryParam("redirect_uri", new Object[]{redirectUrl}).build(new Object[0]).toASCIIString());
    }
}

