/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class AdapterDeploymentContextBean
implements InitializingBean {
    private final Resource keycloakConfigFileResource;
    private AdapterDeploymentContext deploymentContext;
    private KeycloakDeployment deployment;

    public AdapterDeploymentContextBean(Resource keycloakConfigFileResource) {
        this.keycloakConfigFileResource = keycloakConfigFileResource;
    }

    public void afterPropertiesSet() throws Exception {
        this.deployment = this.loadKeycloakDeployment();
        this.deploymentContext = new AdapterDeploymentContext(this.deployment);
    }

    private KeycloakDeployment loadKeycloakDeployment() throws IOException {
        if (!this.keycloakConfigFileResource.isReadable()) {
            throw new FileNotFoundException(String.format("Unable to locate Keycloak configuration file: %s", this.keycloakConfigFileResource.getFilename()));
        }
        return KeycloakDeploymentBuilder.build((InputStream)this.keycloakConfigFileResource.getInputStream());
    }

    public AdapterDeploymentContext getDeploymentContext() {
        return this.deploymentContext;
    }

    public KeycloakDeployment getDeployment() {
        return this.deployment;
    }
}

