/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AuthenticatedActionsHandler;
import org.keycloak.adapters.NodesRegistrationManagement;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.springsecurity.facade.SimpleHttpFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.filter.GenericFilterBean;

public class KeycloakAuthenticatedActionsFilter
extends GenericFilterBean
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(KeycloakAuthenticatedActionsFilter.class);
    private final NodesRegistrationManagement management = new NodesRegistrationManagement();
    private ApplicationContext applicationContext;
    private AdapterDeploymentContext deploymentContext;

    protected void initFilterBean() throws ServletException {
        this.deploymentContext = (AdapterDeploymentContext)this.applicationContext.getBean(AdapterDeploymentContext.class);
    }

    public void destroy() {
        log.debug("Unregistering deployment");
        this.management.stop();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SimpleHttpFacade facade = new SimpleHttpFacade((HttpServletRequest)request, (HttpServletResponse)response);
        AuthenticatedActionsHandler handler = new AuthenticatedActionsHandler(this.deploymentContext.resolveDeployment((HttpFacade)facade), (OIDCHttpFacade)facade);
        boolean handled = handler.handledRequest();
        if (handled) {
            log.debug("Authenticated filter handled request: {}", (Object)((HttpServletRequest)request).getRequestURI());
        } else {
            chain.doFilter(request, response);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

