/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.freedesktop.dbus.Variant;
import org.jboss.logging.Logger;
import org.keycloak.federation.sssd.ReadonlySSSDUserModelDelegate;
import org.keycloak.federation.sssd.SSSDFederationProviderFactory;
import org.keycloak.federation.sssd.api.Sssd;
import org.keycloak.federation.sssd.impl.PAMAuthenticator;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.managers.UserManager;

public class SSSDFederationProvider
implements UserFederationProvider {
    private static final Logger logger = Logger.getLogger(SSSDFederationProvider.class);
    protected static final Set<String> supportedCredentialTypes = new HashSet<String>();
    private final SSSDFederationProviderFactory factory;
    protected KeycloakSession session;
    protected UserFederationProviderModel model;

    public SSSDFederationProvider(KeycloakSession session, UserFederationProviderModel model, SSSDFederationProviderFactory sssdFederationProviderFactory) {
        this.session = session;
        this.model = model;
        this.factory = sssdFederationProviderFactory;
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        return this.findOrCreateAuthenticatedUser(realm, username);
    }

    protected UserModel findOrCreateAuthenticatedUser(RealmModel realm, String username) {
        UserModel user = this.session.userStorage().getUserByUsername(username, realm);
        if (user != null) {
            logger.debug((Object)("SSSD authenticated user " + username + " found in Keycloak storage"));
            if (!this.model.getId().equals(user.getFederationLink())) {
                logger.warn((Object)("User with username " + username + " already exists, but is not linked to provider [" + this.model.getDisplayName() + "]"));
                return null;
            }
            UserModel proxied = this.validateAndProxy(realm, user);
            if (proxied != null) {
                return proxied;
            }
            logger.warn((Object)("User with username " + username + " already exists and is linked to provider [" + this.model.getDisplayName() + "] but principal is not correct."));
            logger.warn((Object)"Will re-create user");
            new UserManager(this.session).removeUser(realm, user, this.session.userStorage());
        }
        logger.debug((Object)("SSSD authenticated user " + username + " not in Keycloak storage. Creating..."));
        return this.importUserToKeycloak(realm, username);
    }

    protected UserModel importUserToKeycloak(RealmModel realm, String username) {
        Sssd sssd = new Sssd(username);
        Map<String, Variant> sssdUser = sssd.getUserAttributes();
        logger.debugf("Creating SSSD user: %s to local Keycloak storage", (Object)username);
        UserModel user = this.session.userStorage().addUser(realm, username);
        user.setEnabled(true);
        user.setEmail(Sssd.getRawAttribute(sssdUser.get("mail")));
        user.setFirstName(Sssd.getRawAttribute(sssdUser.get("givenname")));
        user.setLastName(Sssd.getRawAttribute(sssdUser.get("sn")));
        for (String s : sssd.getUserGroups()) {
            GroupModel group2 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)("/" + s));
            if (group2 == null) {
                group2 = this.session.realms().createGroup(realm, s);
            }
            user.joinGroup(group2);
        }
        user.setFederationLink(this.model.getId());
        return this.validateAndProxy(realm, user);
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        return null;
    }

    public List<UserModel> searchByAttributes(Map<String, String> attributes, RealmModel realm, int maxResults) {
        return Collections.emptyList();
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group2, int firstResult, int maxResults) {
        return Collections.emptyList();
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public void preRemove(RealmModel realm, GroupModel group2) {
    }

    public boolean isValid(RealmModel realm, UserModel local) {
        Map<String, Variant> attributes = new Sssd(local.getUsername()).getUserAttributes();
        return Sssd.getRawAttribute(attributes.get("mail")).equalsIgnoreCase(local.getEmail());
    }

    public Set<String> getSupportedCredentialTypes(UserModel user) {
        return supportedCredentialTypes;
    }

    public Set<String> getSupportedCredentialTypes() {
        return supportedCredentialTypes;
    }

    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        for (UserCredentialModel cred : input) {
            if (!cred.getType().equals("password")) continue;
            PAMAuthenticator pam = this.factory.createPAMAuthenticator(user.getUsername(), cred.getValue());
            return pam.authenticate() != null;
        }
        return false;
    }

    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return this.validCredentials(realm, user, Arrays.asList(input));
    }

    public CredentialValidationOutput validCredentials(RealmModel realm, UserCredentialModel credential) {
        return CredentialValidationOutput.failed();
    }

    public UserModel validateAndProxy(RealmModel realm, UserModel local) {
        if (this.isValid(realm, local)) {
            return new ReadonlySSSDUserModelDelegate(local, this);
        }
        return null;
    }

    public boolean synchronizeRegistrations() {
        return false;
    }

    public UserModel register(RealmModel realm, UserModel user) {
        throw new IllegalStateException("Registration not supported");
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        return true;
    }

    public void close() {
        Sssd.disconnect();
    }

    static {
        supportedCredentialTypes.add("password");
    }
}

