/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.freedesktop.dbus.Gettext;

public class BusAddress {
    private String type;
    private Map<String, String> parameters;

    public BusAddress(String address) throws ParseException {
        if (null == address || "".equals(address)) {
            throw new ParseException(Gettext.getString("busAddressBlank"), 0);
        }
        String[] ss = address.split(":", 2);
        if (ss.length < 2) {
            throw new ParseException(Gettext.getString("busAddressInvalid") + address, 0);
        }
        this.type = ss[0];
        String[] ps = ss[1].split(",");
        this.parameters = new HashMap<String, String>();
        for (String p : ps) {
            String[] kv = p.split("=", 2);
            this.parameters.put(kv[0], kv[1]);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public String toString() {
        return this.type + ": " + this.parameters;
    }
}

