/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.freedesktop.dbus.Variant;
import org.jboss.logging.Logger;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.federation.sssd.ReadonlySSSDUserModelDelegate;
import org.keycloak.federation.sssd.SSSDFederationProviderFactory;
import org.keycloak.federation.sssd.api.Sssd;
import org.keycloak.federation.sssd.impl.PAMAuthenticator;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserLookupProvider;

public class SSSDFederationProvider
implements UserStorageProvider,
UserLookupProvider,
CredentialInputUpdater,
CredentialInputValidator,
ImportedUserValidation {
    private static final Logger logger = Logger.getLogger(SSSDFederationProvider.class);
    protected static final Set<String> supportedCredentialTypes = new HashSet<String>();
    private final SSSDFederationProviderFactory factory;
    protected KeycloakSession session;
    protected UserStorageProviderModel model;

    public SSSDFederationProvider(KeycloakSession session, UserStorageProviderModel model, SSSDFederationProviderFactory sssdFederationProviderFactory) {
        this.session = session;
        this.model = model;
        this.factory = sssdFederationProviderFactory;
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        return this.findOrCreateAuthenticatedUser(realm, username);
    }

    public UserModel validate(RealmModel realm, UserModel user) {
        return this.validateAndProxy(realm, user);
    }

    protected UserModel findOrCreateAuthenticatedUser(RealmModel realm, String username) {
        UserModel user = this.session.userLocalStorage().getUserByUsername(username, realm);
        if (user != null) {
            logger.debug((Object)("SSSD authenticated user " + username + " found in Keycloak storage"));
            if (!this.model.getId().equals(user.getFederationLink())) {
                logger.warn((Object)("User with username " + username + " already exists, but is not linked to provider [" + this.model.getName() + "]"));
                return null;
            }
            UserModel proxied = this.validateAndProxy(realm, user);
            if (proxied != null) {
                return proxied;
            }
            logger.warn((Object)("User with username " + username + " already exists and is linked to provider [" + this.model.getName() + "] but principal is not correct."));
            logger.warn((Object)"Will re-create user");
            new UserManager(this.session).removeUser(realm, user, this.session.userLocalStorage());
        }
        logger.debug((Object)("SSSD authenticated user " + username + " not in Keycloak storage. Creating..."));
        return this.importUserToKeycloak(realm, username);
    }

    protected UserModel importUserToKeycloak(RealmModel realm, String username) {
        Sssd sssd = new Sssd(username);
        Map<String, Variant> sssdUser = sssd.getUserAttributes();
        logger.debugf("Creating SSSD user: %s to local Keycloak storage", (Object)username);
        UserModel user = this.session.userLocalStorage().addUser(realm, username);
        user.setEnabled(true);
        user.setEmail(Sssd.getRawAttribute(sssdUser.get("mail")));
        user.setFirstName(Sssd.getRawAttribute(sssdUser.get("givenname")));
        user.setLastName(Sssd.getRawAttribute(sssdUser.get("sn")));
        for (String s : sssd.getUserGroups()) {
            GroupModel group2 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)("/" + s));
            if (group2 == null) {
                group2 = this.session.realms().createGroup(realm, s);
            }
            user.joinGroup(group2);
        }
        user.setFederationLink(this.model.getId());
        return this.validateAndProxy(realm, user);
    }

    public UserModel getUserById(String id, RealmModel realm) {
        return null;
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        return null;
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public void preRemove(RealmModel realm, GroupModel group2) {
    }

    public boolean isValid(RealmModel realm, UserModel local) {
        Map<String, Variant> attributes = new Sssd(local.getUsername()).getUserAttributes();
        return Sssd.getRawAttribute(attributes.get("mail")).equalsIgnoreCase(local.getEmail());
    }

    public boolean supportsCredentialType(String credentialType) {
        return "password".equals(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return "password".equals(credentialType);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!this.supportsCredentialType(input.getType()) || !(input instanceof UserCredentialModel)) {
            return false;
        }
        UserCredentialModel cred = (UserCredentialModel)input;
        PAMAuthenticator pam = this.factory.createPAMAuthenticator(user.getUsername(), cred.getValue());
        return pam.authenticate() != null;
    }

    public UserModel validateAndProxy(RealmModel realm, UserModel local) {
        if (this.isValid(realm, local)) {
            return new ReadonlySSSDUserModelDelegate(local, this);
        }
        return null;
    }

    public void close() {
        Sssd.disconnect();
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        throw new IllegalStateException("You can't update your password as your account is read only.");
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
    }

    public Set<String> getDisableableCredentialTypes(RealmModel realm, UserModel user) {
        return Collections.EMPTY_SET;
    }

    static {
        supportedCredentialTypes.add("password");
    }
}

