/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistration;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.test.builders.ClientBuilder;

public class FluentTestsHelper {
    public static final String DEFAULT_KEYCLOAK_URL = "http://localhost:8080/auth";
    public static final String DEFAULT_ADMIN_USERNAME = "admin";
    public static final String DEFAULT_ADMIN_PASSWORD = "admin";
    public static final String DEFAULT_ADMIN_REALM = "master";
    public static final String DEFAULT_ADMIN_CLIENT = "admin-cli";
    public static final String DEFAULT_TEST_REALM = "master";
    public static final String DEFAULT_USER_ROLE = "user";
    protected final String keycloakBaseUrl;
    protected final String adminUserName;
    protected final String adminPassword;
    protected final String adminClient;
    protected final String adminRealm;
    protected String testRealm;
    protected Keycloak keycloak;
    protected String accessToken;
    protected volatile boolean isInitialized;
    protected Map<String, ClientData> createdClients = new HashMap<String, ClientData>();

    public FluentTestsHelper() {
        this("admin", "admin");
    }

    public FluentTestsHelper(String adminUserName, String adminPassword) {
        this(DEFAULT_KEYCLOAK_URL, adminUserName, adminPassword, "master", DEFAULT_ADMIN_CLIENT, "master");
    }

    public FluentTestsHelper(String keycloakBaseUrl, String adminUserName, String adminPassword, String adminRealm, String adminClient, String testRealm) {
        this.keycloakBaseUrl = keycloakBaseUrl;
        this.testRealm = testRealm;
        this.adminUserName = adminUserName;
        this.adminPassword = adminPassword;
        this.adminRealm = adminRealm;
        this.adminClient = adminClient;
    }

    public FluentTestsHelper init() {
        this.keycloak = this.getKeycloakInstance(DEFAULT_KEYCLOAK_URL, this.adminRealm, this.adminUserName, this.adminPassword, this.adminClient);
        this.accessToken = this.generateInitialAccessToken();
        this.isInitialized = true;
        return this;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    protected Keycloak getKeycloakInstance(String keycloakBaseUrl, String realm, String username, String password, String clientId) {
        return Keycloak.getInstance((String)keycloakBaseUrl, (String)realm, (String)username, (String)password, (String)clientId);
    }

    protected String generateInitialAccessToken() {
        ClientInitialAccessCreatePresentation rep = new ClientInitialAccessCreatePresentation();
        rep.setCount(Integer.valueOf(2));
        rep.setExpiration(Integer.valueOf(180));
        ClientInitialAccessPresentation initialAccess = this.keycloak.realms().realm(this.testRealm).clientInitialAccess().create(rep);
        return initialAccess.getToken();
    }

    public FluentTestsHelper createClient(ClientRepresentation clientRepresentation) throws ClientRegistrationException, JsonProcessingException {
        assert (this.isInitialized);
        ClientRegistration reg = ClientRegistration.create().url(this.keycloakBaseUrl, this.testRealm).build();
        reg.auth(Auth.token((String)this.accessToken));
        clientRepresentation = reg.create(clientRepresentation);
        String registrationAccessCode = clientRepresentation.getRegistrationAccessToken();
        reg.auth(Auth.token((String)registrationAccessCode));
        this.createdClients.put(clientRepresentation.getClientId(), new ClientData(clientRepresentation, registrationAccessCode));
        return this;
    }

    public FluentTestsHelper createDirectGrantClient(String clientId) throws ClientRegistrationException, JsonProcessingException {
        assert (this.isInitialized);
        this.createClient(ClientBuilder.create(clientId).accessType(ClientBuilder.AccessType.PUBLIC));
        return this;
    }

    public FluentTestsHelper deleteClient(String clientId) throws ClientRegistrationException {
        assert (this.isInitialized);
        ClientData clientData = this.createdClients.get(clientId);
        if (clientData == null) {
            throw new ClientRegistrationException("This client wasn't created by this helper!");
        }
        ClientRegistration reg = ClientRegistration.create().url(this.keycloakBaseUrl, this.testRealm).build();
        reg.auth(Auth.token((String)clientData.getRegistrationCode()));
        reg.delete(clientId);
        return this;
    }

    public FluentTestsHelper importTestRealm(String realmJsonPath) throws IOException {
        return this.importTestRealm(FluentTestsHelper.class.getResourceAsStream(realmJsonPath));
    }

    public FluentTestsHelper importTestRealm(File realmJsonPath) throws IOException {
        try (FileInputStream fis = new FileInputStream(realmJsonPath);){
            FluentTestsHelper fluentTestsHelper = this.importTestRealm(fis);
            return fluentTestsHelper;
        }
    }

    public FluentTestsHelper importTestRealm(InputStream stream) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        RealmRepresentation realmRepresentation = (RealmRepresentation)mapper.readValue(stream, RealmRepresentation.class);
        this.keycloak.realms().create(realmRepresentation);
        this.testRealm = realmRepresentation.getRealm();
        this.accessToken = this.generateInitialAccessToken();
        return this;
    }

    public FluentTestsHelper deleteRealm(String realmName) {
        this.keycloak.realms().realm(realmName).remove();
        return this;
    }

    public FluentTestsHelper createTestUser(String username, String password) {
        UserRepresentation userRepresentation = new UserRepresentation();
        userRepresentation.setUsername(username);
        userRepresentation.setEnabled(Boolean.valueOf(true));
        Response response = this.keycloak.realms().realm(this.testRealm).users().create(userRepresentation);
        String userId = this.getCreatedId(response);
        response.close();
        CredentialRepresentation rep = new CredentialRepresentation();
        rep.setType("password");
        rep.setValue(password);
        rep.setTemporary(Boolean.valueOf(false));
        this.keycloak.realms().realm(this.testRealm).users().get(userId).resetPassword(rep);
        return this;
    }

    public FluentTestsHelper assignRoleWithUser(String userName, String roleName) {
        if (this.keycloak.realms().realm(this.testRealm).roles().get(roleName) == null) {
            RoleRepresentation representation = new RoleRepresentation();
            representation.setName(roleName);
            this.keycloak.realms().realm(this.testRealm).roles().create(representation);
        }
        UserRepresentation userRepresentation = (UserRepresentation)this.keycloak.realms().realm(this.testRealm).users().search(userName).get(0);
        RoleRepresentation realmRole = this.keycloak.realms().realm(this.testRealm).roles().get(roleName).toRepresentation();
        this.keycloak.realms().realm(this.testRealm).users().get(userRepresentation.getId()).roles().realmLevel().add(Arrays.asList(realmRole));
        return this;
    }

    public FluentTestsHelper deleteRole(String roleName) {
        RoleResource role = this.keycloak.realms().realm(this.testRealm).roles().get(roleName);
        if (role != null) {
            this.keycloak.realms().realm(this.testRealm).roles().deleteRole(roleName);
        }
        return this;
    }

    public FluentTestsHelper deleteTestUser(String userName) {
        UserRepresentation userInKeycloak = (UserRepresentation)this.keycloak.realms().realm(this.testRealm).users().search(userName).get(0);
        if (userInKeycloak != null) {
            this.keycloak.realms().realm(this.testRealm).users().delete(userInKeycloak.getId());
        }
        return this;
    }

    protected String getCreatedId(Response response) {
        URI location = response.getLocation();
        if (!response.getStatusInfo().equals(Response.Status.CREATED)) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new WebApplicationException("Create method returned status " + statusInfo.getReasonPhrase() + " (Code: " + statusInfo.getStatusCode() + "); expected status: Created (201)", response);
        }
        if (location == null) {
            return null;
        }
        String path = location.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testGetWithAuth(String endpoint, String token) throws IOException {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            boolean bl;
            HttpGet get = new HttpGet(this.keycloakBaseUrl + endpoint);
            get.addHeader("Authorization", "Bearer " + token);
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                boolean bl2 = false;
                return bl2;
            }
            HttpEntity entity = response.getEntity();
            InputStream is = entity.getContent();
            try {
                bl = true;
            }
            catch (Throwable throwable) {
                is.close();
                throw throwable;
            }
            is.close();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean returnsForbidden(String endpoint) throws IOException {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpGet get = new HttpGet(this.keycloakBaseUrl + endpoint);
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 403 || response.getStatusLine().getStatusCode() == 401) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public String getToken() {
        assert (this.isInitialized);
        return this.keycloak.tokenManager().getAccessTokenString();
    }

    protected static class ClientData {
        private final ClientRepresentation clientRepresentation;
        private final String registrationCode;

        public ClientData(ClientRepresentation clientRepresentation, String registrationCode) {
            this.clientRepresentation = clientRepresentation;
            this.registrationCode = registrationCode;
        }

        public ClientRepresentation getClientRepresentation() {
            return this.clientRepresentation;
        }

        public String getRegistrationCode() {
            return this.registrationCode;
        }
    }
}

