/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.testsuite.adapter.AdapterTestStrategy;
import org.keycloak.testsuite.rule.AbstractKeycloakRule;

public class Jetty8Test {
    @ClassRule
    public static AbstractKeycloakRule keycloakRule = new AbstractKeycloakRule(){

        protected void configure(KeycloakSession session, RealmManager manager, RealmModel adminRealm) {
            AdapterTestStrategy.baseAdapterTestInitialization((KeycloakSession)session, (RealmManager)manager, (RealmModel)adminRealm, ((Object)((Object)this)).getClass());
        }
    };
    public static Server server = null;
    @Rule
    public AdapterTestStrategy testStrategy = new AdapterTestStrategy("http://localhost:8081/auth", "http://localhost:8082", keycloakRule, true);

    @BeforeClass
    public static void initJetty() throws Exception {
        server = new Server(8082);
        ArrayList<WebAppContext> list = new ArrayList<WebAppContext>();
        System.setProperty("app.server.base.url", "http://localhost:8082");
        System.setProperty("my.host.name", "localhost");
        URL dir = Jetty8Test.class.getResource("/adapter-test/demorealm.json");
        File base = new File(dir.getFile()).getParentFile();
        list.add(new WebAppContext(new File(base, "customer-portal").toString(), "/customer-portal"));
        list.add(new WebAppContext(new File(base, "customer-db").toString(), "/customer-db"));
        list.add(new WebAppContext(new File(base, "customer-db-error-page").toString(), "/customer-db-error-page"));
        list.add(new WebAppContext(new File(base, "product-portal").toString(), "/product-portal"));
        list.add(new WebAppContext(new File(base, "session-portal").toString(), "/session-portal"));
        list.add(new WebAppContext(new File(base, "input-portal").toString(), "/input-portal"));
        list.add(new WebAppContext(new File(base, "secure-portal").toString(), "/secure-portal"));
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(list.toArray(new Handler[list.size()]));
        server.setHandler((Handler)handlers);
        server.start();
    }

    @AfterClass
    public static void shutdownJetty() throws Exception {
        try {
            server.stop();
            server.destroy();
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSavedPostRequest() throws Exception {
        this.testStrategy.testSavedPostRequest();
    }

    @Test
    public void testLoginSSOAndLogout() throws Exception {
        this.testStrategy.testLoginSSOAndLogout();
    }

    @Test
    public void testServletRequestLogout() throws Exception {
        this.testStrategy.testServletRequestLogout();
    }

    @Test
    public void testLoginSSOIdle() throws Exception {
        this.testStrategy.testLoginSSOIdle();
    }

    @Test
    public void testLoginSSOIdleRemoveExpiredUserSessions() throws Exception {
        this.testStrategy.testLoginSSOIdleRemoveExpiredUserSessions();
    }

    @Test
    public void testLoginSSOMax() throws Exception {
        this.testStrategy.testLoginSSOMax();
    }

    @Test
    public void testNullBearerToken() throws Exception {
        this.testStrategy.testNullBearerToken();
    }

    @Test
    public void testNullBearerTokenCustomErrorPage() throws Exception {
        this.testStrategy.testNullBearerTokenCustomErrorPage();
    }

    @Test
    public void testBadUser() throws Exception {
        this.testStrategy.testBadUser();
    }

    @Test
    public void testVersion() throws Exception {
        this.testStrategy.testVersion();
    }

    @Test
    public void testSingleSessionInvalidated() throws Throwable {
        this.testStrategy.testSingleSessionInvalidated();
    }

    @Test
    public void testSessionInvalidatedAfterFailedRefresh() throws Throwable {
        this.testStrategy.testSessionInvalidatedAfterFailedRefresh();
    }

    @Test
    public void testAdminApplicationLogout() throws Throwable {
        this.testStrategy.testAdminApplicationLogout();
    }

    @Test
    public void testAccountManagementSessionsLogout() throws Throwable {
        this.testStrategy.testAccountManagementSessionsLogout();
    }
}

