/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.testsuite.keycloaksaml.SamlAdapterTestStrategy;
import org.keycloak.testsuite.rule.AbstractKeycloakRule;
import org.openqa.selenium.WebDriver;

public class JettySamlTest {
    @Rule
    public SamlAdapterTestStrategy testStrategy = new SamlAdapterTestStrategy("http://localhost:8081/auth", "http://localhost:8082", keycloakRule);
    @ClassRule
    public static AbstractKeycloakRule keycloakRule = new AbstractKeycloakRule(){

        protected void configure(KeycloakSession session, RealmManager manager, RealmModel adminRealm) {
            SamlAdapterTestStrategy.baseAdapterTestInitialization((KeycloakSession)session, (RealmManager)manager, (RealmModel)adminRealm, ((Object)((Object)this)).getClass());
        }
    };
    public static Server server = null;

    @BeforeClass
    public static void initJetty() throws Exception {
        server = new Server(8082);
        ArrayList<WebAppContext> list = new ArrayList<WebAppContext>();
        System.setProperty("app.server.base.url", "http://localhost:8082");
        System.setProperty("my.host.name", "localhost");
        URL dir = JettySamlTest.class.getResource("/keycloak-saml/testsaml.json");
        File base = new File(dir.getFile()).getParentFile();
        list.add(new WebAppContext(new File(base, "simple-post").toString(), "/sales-post"));
        list.add(new WebAppContext(new File(base, "simple-post2").toString(), "/sales-post2"));
        list.add(new WebAppContext(new File(base, "simple-input").toString(), "/input-portal"));
        list.add(new WebAppContext(new File(base, "signed-post").toString(), "/sales-post-sig"));
        list.add(new WebAppContext(new File(base, "signed-post-email").toString(), "/sales-post-sig-email"));
        list.add(new WebAppContext(new File(base, "signed-post-transient").toString(), "/sales-post-sig-transient"));
        list.add(new WebAppContext(new File(base, "signed-post-persistent").toString(), "/sales-post-sig-persistent"));
        list.add(new WebAppContext(new File(base, "signed-metadata").toString(), "/sales-metadata"));
        list.add(new WebAppContext(new File(base, "signed-get").toString(), "/employee-sig"));
        list.add(new WebAppContext(new File(base, "mappers").toString(), "/employee2"));
        list.add(new WebAppContext(new File(base, "signed-front-get").toString(), "/employee-sig-front"));
        list.add(new WebAppContext(new File(base, "bad-client-signed-post").toString(), "/bad-client-sales-post-sig"));
        list.add(new WebAppContext(new File(base, "bad-realm-signed-post").toString(), "/bad-realm-sales-post-sig"));
        list.add(new WebAppContext(new File(base, "encrypted-post").toString(), "/sales-post-enc"));
        SamlAdapterTestStrategy.uploadSP((String)"http://localhost:8081/auth");
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(list.toArray(new Handler[list.size()]));
        server.setHandler((Handler)handlers);
        server.start();
    }

    @AfterClass
    public static void shutdownJetty() throws Exception {
        try {
            server.stop();
            server.destroy();
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSavedPostRequest() throws Exception {
        this.testStrategy.testSavedPostRequest();
    }

    @Test
    public void testPostSimpleLoginLogoutIdpInitiatedRedirectTo() {
        this.testStrategy.testPostSimpleLoginLogoutIdpInitiatedRedirectTo();
    }

    @Test
    public void testErrorHandling() throws Exception {
        this.testStrategy.testErrorHandling();
    }

    @Test
    public void testPostSimpleLoginLogout() {
        this.testStrategy.testPostSimpleLoginLogout();
    }

    @Test
    public void testPostSimpleLoginLogoutIdpInitiated() {
        this.testStrategy.testPostSimpleLoginLogoutIdpInitiated();
    }

    @Test
    public void testPostSignedLoginLogout() {
        this.testStrategy.testPostSignedLoginLogout();
    }

    @Test
    public void testPostSignedLoginLogoutTransientNameID() {
        this.testStrategy.testPostSignedLoginLogoutTransientNameID();
    }

    @Test
    public void testPostSignedLoginLogoutPersistentNameID() {
        this.testStrategy.testPostSignedLoginLogoutPersistentNameID();
    }

    @Test
    public void testPostSignedLoginLogoutEmailNameID() {
        this.testStrategy.testPostSignedLoginLogoutEmailNameID();
    }

    @Test
    public void testAttributes() throws Exception {
        this.testStrategy.testAttributes();
    }

    @Test
    public void testRedirectSignedLoginLogout() {
        this.testStrategy.testRedirectSignedLoginLogout();
    }

    @Test
    public void testRedirectSignedLoginLogoutFrontNoSSO() {
        this.testStrategy.testRedirectSignedLoginLogoutFrontNoSSO();
    }

    @Test
    public void testRedirectSignedLoginLogoutFront() {
        this.testStrategy.testRedirectSignedLoginLogoutFront();
    }

    @Test
    public void testPostEncryptedLoginLogout() {
        this.testStrategy.testPostEncryptedLoginLogout();
    }

    @Test
    public void testPostBadClientSignature() {
        this.testStrategy.testPostBadClientSignature();
    }

    @Test
    public void testPostBadRealmSignature() {
        this.testStrategy.testPostBadRealmSignature();
    }

    @Test
    public void testPostSimpleUnauthorized() {
        this.testStrategy.testPostSimpleUnauthorized(new SamlAdapterTestStrategy.CheckAuthError(){

            public void check(WebDriver driver) {
                Assert.assertTrue((boolean)driver.getPageSource().contains("Error 403 !role"));
            }
        });
    }

    @Test
    public void testMetadataPostSignedLoginLogout() throws Exception {
        this.testStrategy.testMetadataPostSignedLoginLogout();
    }
}

