/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.testsuite.TomcatServer;
import org.keycloak.testsuite.keycloaksaml.SamlAdapterTestStrategy;
import org.keycloak.testsuite.rule.AbstractKeycloakRule;
import org.openqa.selenium.WebDriver;

public class TomcatSamlTest {
    @ClassRule
    public static AbstractKeycloakRule keycloakRule = new AbstractKeycloakRule(){

        protected void configure(KeycloakSession session, RealmManager manager, RealmModel adminRealm) {
            SamlAdapterTestStrategy.baseAdapterTestInitialization((KeycloakSession)session, (RealmManager)manager, (RealmModel)adminRealm, ((Object)((Object)this)).getClass());
        }
    };
    static TomcatServer tomcat = null;
    @Rule
    public SamlAdapterTestStrategy testStrategy = new SamlAdapterTestStrategy("http://localhost:8081/auth", "http://localhost:8082", keycloakRule);

    @BeforeClass
    public static void initTomcat() throws Exception {
        URL dir = TomcatSamlTest.class.getResource("/keycloak-saml/testsaml.json");
        String baseDir = new File(dir.getFile()).getParentFile().toString();
        System.out.println("Tomcat basedir: " + baseDir);
        tomcat = new TomcatServer(8082, baseDir);
        System.setProperty("app.server.base.url", "http://localhost:8082");
        System.setProperty("my.host.name", "localhost");
        tomcat.deploySaml("/sales-post", "simple-post");
        tomcat.deploySaml("/sales-post2", "simple-post2");
        tomcat.deploySaml("/input-portal", "simple-input");
        tomcat.deploySaml("/sales-post-sig", "signed-post");
        tomcat.deploySaml("/sales-post-sig-email", "signed-post-email");
        tomcat.deploySaml("/sales-post-sig-transient", "signed-post-transient");
        tomcat.deploySaml("/sales-post-sig-persistent", "signed-post-persistent");
        tomcat.deploySaml("/sales-metadata", "signed-metadata");
        tomcat.deploySaml("/employee-sig", "signed-get");
        tomcat.deploySaml("/employee2", "mappers");
        tomcat.deploySaml("/employee-sig-front", "signed-front-get");
        tomcat.deploySaml("/bad-client-sales-post-sig", "bad-client-signed-post");
        tomcat.deploySaml("/bad-realm-sales-post-sig", "bad-realm-signed-post");
        tomcat.deploySaml("/sales-post-enc", "encrypted-post");
        SamlAdapterTestStrategy.uploadSP((String)"http://localhost:8081/auth");
        tomcat.start();
    }

    @AfterClass
    public static void shutdownTomcat() throws Exception {
        tomcat.stop();
    }

    @Test
    public void testSavedPostRequest() throws Exception {
        this.testStrategy.testSavedPostRequest();
    }

    @Test
    public void testPostSimpleLoginLogoutIdpInitiatedRedirectTo() {
        this.testStrategy.testPostSimpleLoginLogoutIdpInitiatedRedirectTo();
    }

    @Test
    public void testPostSimpleLoginLogout() {
        this.testStrategy.testPostSimpleLoginLogout();
    }

    @Test
    public void testPostSimpleLoginLogoutIdpInitiated() {
        this.testStrategy.testPostSimpleLoginLogoutIdpInitiated();
    }

    @Test
    public void testPostSignedLoginLogout() {
        this.testStrategy.testPostSignedLoginLogout();
    }

    @Test
    public void testPostSignedLoginLogoutTransientNameID() {
        this.testStrategy.testPostSignedLoginLogoutTransientNameID();
    }

    @Test
    public void testPostSignedLoginLogoutPersistentNameID() {
        this.testStrategy.testPostSignedLoginLogoutPersistentNameID();
    }

    @Test
    public void testErrorHandling() throws Exception {
        this.testStrategy.testErrorHandling();
    }

    @Test
    public void testPostSignedLoginLogoutEmailNameID() {
        this.testStrategy.testPostSignedLoginLogoutEmailNameID();
    }

    @Test
    public void testAttributes() throws Exception {
        this.testStrategy.testAttributes();
    }

    @Test
    public void testRedirectSignedLoginLogout() {
        this.testStrategy.testRedirectSignedLoginLogout();
    }

    @Test
    public void testRedirectSignedLoginLogoutFrontNoSSO() {
        this.testStrategy.testRedirectSignedLoginLogoutFrontNoSSO();
    }

    @Test
    public void testRedirectSignedLoginLogoutFront() {
        this.testStrategy.testRedirectSignedLoginLogoutFront();
    }

    @Test
    public void testPostEncryptedLoginLogout() {
        this.testStrategy.testPostEncryptedLoginLogout();
    }

    @Test
    public void testPostBadClientSignature() {
        this.testStrategy.testPostBadClientSignature();
    }

    @Test
    public void testPostBadRealmSignature() {
        this.testStrategy.testPostBadRealmSignature();
    }

    @Test
    public void testPostSimpleUnauthorized() {
        this.testStrategy.testPostSimpleUnauthorized(new SamlAdapterTestStrategy.CheckAuthError(){

            public void check(WebDriver driver) {
                Assert.assertTrue((boolean)driver.getPageSource().contains("forbidden"));
            }
        });
    }

    @Test
    public void testMetadataPostSignedLoginLogout() throws Exception {
        this.testStrategy.testMetadataPostSignedLoginLogout();
    }

    static String getBaseDirectory() {
        String dirPath = null;
        String relativeDirPath = "testsuite" + File.separator + "tomcat6" + File.separator + "target";
        if (System.getProperties().containsKey("maven.home")) {
            dirPath = System.getProperty("user.dir").replaceFirst("testsuite.tomcat6.*", Matcher.quoteReplacement(relativeDirPath));
        } else {
            for (String c : System.getProperty("java.class.path").split(File.pathSeparator)) {
                if (!c.contains(File.separator + "testsuite" + File.separator + "tomcat6")) continue;
                dirPath = c.replaceFirst("testsuite.tomcat6.*", Matcher.quoteReplacement(relativeDirPath));
                break;
            }
        }
        String absolutePath = new File(dirPath).getAbsolutePath();
        return absolutePath;
    }
}

