/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Embedded;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.tomcat.SamlAuthenticatorValve;
import org.keycloak.adapters.tomcat.KeycloakAuthenticatorValve;
import org.keycloak.testsuite.TomcatTest;

public class TomcatServer {
    private Embedded server;
    private int port;
    private boolean isRunning;
    private static final Logger LOG = Logger.getLogger(TomcatServer.class);
    private static final boolean isInfo = LOG.isInfoEnabled();
    private final Host host;

    public TomcatServer(int port, String appBase) {
        this.port = port;
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.server = new Embedded();
        this.server.setName("TomcatEmbeddedServer");
        this.server.setCatalinaBase(TomcatTest.getBaseDirectory());
        this.host = this.server.createHost("localhost", appBase);
        this.host.setAutoDeploy(false);
    }

    public void deploy(String contextPath, String appDir) {
        if (contextPath == null) {
            throw new IllegalArgumentException("Context path or appbase should not be null");
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        StandardContext rootContext = (StandardContext)this.server.createContext(contextPath, appDir);
        KeycloakAuthenticatorValve valve = new KeycloakAuthenticatorValve();
        rootContext.addValve((Valve)valve);
        rootContext.setDefaultWebXml("web.xml");
        this.host.addChild((Container)rootContext);
    }

    public void deploySaml(String contextPath, String appDir) {
        if (contextPath == null) {
            throw new IllegalArgumentException("Context path or appbase should not be null");
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        StandardContext rootContext = (StandardContext)this.server.createContext(contextPath, appDir);
        SamlAuthenticatorValve valve = new SamlAuthenticatorValve();
        rootContext.addValve((Valve)valve);
        rootContext.setDefaultWebXml("web.xml");
        this.host.addChild((Container)rootContext);
    }

    public void start() throws LifecycleException {
        if (this.isRunning) {
            LOG.warnv("Tomcat server is already running @ port={}; ignoring the start", (Object)this.port);
            return;
        }
        Engine engine = this.server.createEngine();
        engine.setDefaultHost(this.host.getName());
        engine.setName("TomcatEngine");
        engine.addChild((Container)this.host);
        this.server.addEngine(engine);
        Connector connector = this.server.createConnector(this.host.getName(), this.port, false);
        this.server.addConnector(connector);
        if (isInfo) {
            LOG.infov("Starting the Tomcat server @ port={}", (Object)this.port);
        }
        this.server.setAwait(true);
        this.server.start();
        this.isRunning = true;
    }

    public void stop() throws LifecycleException {
        if (!this.isRunning) {
            LOG.warnv("Tomcat server is not running @ port={}", (Object)this.port);
            return;
        }
        if (isInfo) {
            LOG.info((Object)"Stopping the Tomcat server");
        }
        this.server.stop();
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

