/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.io.File;
import java.net.URL;
import org.apache.catalina.startup.Tomcat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.testsuite.TomcatTest;
import org.keycloak.testsuite.keycloaksaml.SamlAdapterTestStrategy;
import org.keycloak.testsuite.rule.AbstractKeycloakRule;
import org.openqa.selenium.WebDriver;

public class TomcatSamlTest {
    @ClassRule
    public static AbstractKeycloakRule keycloakRule = new AbstractKeycloakRule(){

        protected void configure(KeycloakSession session, RealmManager manager, RealmModel adminRealm) {
            SamlAdapterTestStrategy.baseAdapterTestInitialization((KeycloakSession)session, (RealmManager)manager, (RealmModel)adminRealm, ((Object)((Object)this)).getClass());
        }
    };
    static Tomcat tomcat = null;
    @Rule
    public SamlAdapterTestStrategy testStrategy = new SamlAdapterTestStrategy("http://localhost:8081/auth", "http://localhost:8082", keycloakRule);

    @BeforeClass
    public static void initTomcat() throws Exception {
        tomcat = new Tomcat();
        String baseDir = TomcatTest.getBaseDirectory();
        tomcat.setBaseDir(baseDir);
        tomcat.setPort(8082);
        System.setProperty("app.server.base.url", "http://localhost:8082");
        System.setProperty("my.host.name", "localhost");
        URL dir = TomcatSamlTest.class.getResource("/keycloak-saml/testsaml.json");
        File base = new File(dir.getFile()).getParentFile();
        tomcat.addWebapp("/sales-post", new File(base, "simple-post").toString());
        tomcat.addWebapp("/sales-post2", new File(base, "simple-post2").toString());
        tomcat.addWebapp("/input-portal", new File(base, "simple-input").toString());
        tomcat.addWebapp("/sales-post-sig", new File(base, "signed-post").toString());
        tomcat.addWebapp("/sales-post-sig-email", new File(base, "signed-post-email").toString());
        tomcat.addWebapp("/sales-post-sig-transient", new File(base, "signed-post-transient").toString());
        tomcat.addWebapp("/sales-post-sig-persistent", new File(base, "signed-post-persistent").toString());
        tomcat.addWebapp("/sales-metadata", new File(base, "signed-metadata").toString());
        tomcat.addWebapp("/employee-sig", new File(base, "signed-get").toString());
        tomcat.addWebapp("/employee2", new File(base, "mappers").toString());
        tomcat.addWebapp("/employee-sig-front", new File(base, "signed-front-get").toString());
        tomcat.addWebapp("/bad-client-sales-post-sig", new File(base, "bad-client-signed-post").toString());
        tomcat.addWebapp("/bad-realm-sales-post-sig", new File(base, "bad-realm-signed-post").toString());
        tomcat.addWebapp("/sales-post-enc", new File(base, "encrypted-post").toString());
        SamlAdapterTestStrategy.uploadSP((String)"http://localhost:8081/auth");
        tomcat.start();
    }

    @AfterClass
    public static void shutdownTomcat() throws Exception {
        tomcat.stop();
        tomcat.destroy();
    }

    @Test
    public void testSavedPostRequest() throws Exception {
        this.testStrategy.testSavedPostRequest();
    }

    @Test
    public void testPostSimpleLoginLogoutIdpInitiatedRedirectTo() {
        this.testStrategy.testPostSimpleLoginLogoutIdpInitiatedRedirectTo();
    }

    @Test
    public void testErrorHandling() throws Exception {
        this.testStrategy.testErrorHandling();
    }

    @Test
    public void testPostSimpleLoginLogout() {
        this.testStrategy.testPostSimpleLoginLogout();
    }

    @Test
    public void testPostSimpleLoginLogoutIdpInitiated() {
        this.testStrategy.testPostSimpleLoginLogoutIdpInitiated();
    }

    @Test
    public void testPostSignedLoginLogout() {
        this.testStrategy.testPostSignedLoginLogout();
    }

    @Test
    public void testPostSignedLoginLogoutTransientNameID() {
        this.testStrategy.testPostSignedLoginLogoutTransientNameID();
    }

    @Test
    public void testPostSignedLoginLogoutPersistentNameID() {
        this.testStrategy.testPostSignedLoginLogoutPersistentNameID();
    }

    @Test
    public void testPostSignedLoginLogoutEmailNameID() {
        this.testStrategy.testPostSignedLoginLogoutEmailNameID();
    }

    @Test
    public void testAttributes() throws Exception {
        this.testStrategy.testAttributes();
    }

    @Test
    public void testRedirectSignedLoginLogout() {
        this.testStrategy.testRedirectSignedLoginLogout();
    }

    @Test
    public void testRedirectSignedLoginLogoutFrontNoSSO() {
        this.testStrategy.testRedirectSignedLoginLogoutFrontNoSSO();
    }

    @Test
    public void testRedirectSignedLoginLogoutFront() {
        this.testStrategy.testRedirectSignedLoginLogoutFront();
    }

    @Test
    public void testPostEncryptedLoginLogout() {
        this.testStrategy.testPostEncryptedLoginLogout();
    }

    @Test
    public void testPostBadClientSignature() {
        this.testStrategy.testPostBadClientSignature();
    }

    @Test
    public void testPostBadRealmSignature() {
        this.testStrategy.testPostBadRealmSignature();
    }

    @Test
    public void testPostSimpleUnauthorized() {
        this.testStrategy.testPostSimpleUnauthorized(new SamlAdapterTestStrategy.CheckAuthError(){

            public void check(WebDriver driver) {
                Assert.assertTrue((boolean)driver.getPageSource().contains("forbidden"));
            }
        });
    }

    @Test
    public void testMetadataPostSignedLoginLogout() throws Exception {
        this.testStrategy.testMetadataPostSignedLoginLogout();
    }
}

