/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import org.apache.catalina.startup.Tomcat;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.testsuite.adapter.AdapterTestStrategy;
import org.keycloak.testsuite.rule.AbstractKeycloakRule;

public class TomcatTest {
    @ClassRule
    public static AbstractKeycloakRule keycloakRule = new AbstractKeycloakRule(){

        protected void configure(KeycloakSession session, RealmManager manager, RealmModel adminRealm) {
            AdapterTestStrategy.baseAdapterTestInitialization((KeycloakSession)session, (RealmManager)manager, (RealmModel)adminRealm, ((Object)((Object)this)).getClass());
        }
    };
    static Tomcat tomcat = null;
    @Rule
    public AdapterTestStrategy testStrategy = new AdapterTestStrategy("http://localhost:8081/auth", "http://localhost:8082", keycloakRule);

    @BeforeClass
    public static void initTomcat() throws Exception {
        tomcat = new Tomcat();
        String baseDir = TomcatTest.getBaseDirectory();
        tomcat.setBaseDir(baseDir);
        tomcat.setPort(8082);
        System.setProperty("app.server.base.url", "http://localhost:8082");
        System.setProperty("my.host.name", "localhost");
        URL dir = TomcatTest.class.getResource("/adapter-test/demorealm.json");
        File base = new File(dir.getFile()).getParentFile();
        tomcat.addWebapp("/customer-portal", new File(base, "customer-portal").toString());
        tomcat.addWebapp("/customer-db", new File(base, "customer-db").toString());
        tomcat.addWebapp("/customer-db-error-page", new File(base, "customer-db-error-page").toString());
        tomcat.addWebapp("/product-portal", new File(base, "product-portal").toString());
        tomcat.addWebapp("/secure-portal", new File(base, "secure-portal").toString());
        tomcat.addWebapp("/session-portal", new File(base, "session-portal").toString());
        tomcat.addWebapp("/input-portal", new File(base, "input-portal").toString());
        tomcat.start();
    }

    @AfterClass
    public static void shutdownTomcat() throws Exception {
        tomcat.stop();
        tomcat.destroy();
    }

    @Test
    public void testLoginSSOAndLogout() throws Exception {
        this.testStrategy.testLoginSSOAndLogout();
    }

    @Test
    public void testSavedPostRequest() throws Exception {
        this.testStrategy.testSavedPostRequest();
    }

    @Test
    public void testServletRequestLogout() throws Exception {
        this.testStrategy.testServletRequestLogout();
    }

    @Test
    public void testLoginSSOIdle() throws Exception {
        this.testStrategy.testLoginSSOIdle();
    }

    @Test
    public void testLoginSSOIdleRemoveExpiredUserSessions() throws Exception {
        this.testStrategy.testLoginSSOIdleRemoveExpiredUserSessions();
    }

    @Test
    public void testLoginSSOMax() throws Exception {
        this.testStrategy.testLoginSSOMax();
    }

    @Test
    public void testNullBearerToken() throws Exception {
        this.testStrategy.testNullBearerToken();
    }

    @Test
    public void testNullBearerTokenCustomErrorPage() throws Exception {
        this.testStrategy.testNullBearerTokenCustomErrorPage();
    }

    @Test
    public void testBadUser() throws Exception {
        this.testStrategy.testBadUser();
    }

    @Test
    public void testVersion() throws Exception {
        this.testStrategy.testVersion();
    }

    @Test
    public void testSingleSessionInvalidated() throws Throwable {
        this.testStrategy.testSingleSessionInvalidated();
    }

    @Test
    public void testSessionInvalidatedAfterFailedRefresh() throws Throwable {
        this.testStrategy.testSessionInvalidatedAfterFailedRefresh();
    }

    @Test
    public void testAdminApplicationLogout() throws Throwable {
        this.testStrategy.testAdminApplicationLogout();
    }

    @Test
    public void testAccountManagementSessionsLogout() throws Throwable {
        this.testStrategy.testAccountManagementSessionsLogout();
    }

    public static String getBaseDirectory() {
        String dirPath = null;
        String relativeDirPath = "testsuite" + File.separator + "tomcat8" + File.separator + "target";
        if (System.getProperties().containsKey("maven.home")) {
            dirPath = System.getProperty("user.dir").replaceFirst("testsuite.tomcat8.*", Matcher.quoteReplacement(relativeDirPath));
        } else {
            for (String c : System.getProperty("java.class.path").split(File.pathSeparator)) {
                if (!c.contains(File.separator + "testsuite" + File.separator + "tomcat8")) continue;
                dirPath = c.replaceFirst("testsuite.tomcat8.*", Matcher.quoteReplacement(relativeDirPath));
                break;
            }
        }
        String absolutePath = new File(dirPath).getAbsolutePath();
        return absolutePath;
    }
}

