/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.resource;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.keycloak.authorization.client.representation.ServerConfiguration;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.authorization.client.util.Throwables;
import org.keycloak.authorization.client.util.TokenCallable;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.PermissionResponse;
import org.keycloak.representations.idm.authorization.PermissionTicketRepresentation;
import org.keycloak.util.JsonSerialization;

public class PermissionResource {
    private final Http http;
    private final ServerConfiguration serverConfiguration;
    private final TokenCallable pat;

    public PermissionResource(Http http, ServerConfiguration serverConfiguration, TokenCallable pat) {
        this.http = http;
        this.serverConfiguration = serverConfiguration;
        this.pat = pat;
    }

    @Deprecated
    public PermissionResponse forResource(PermissionRequest request) {
        return this.create(request);
    }

    public PermissionResponse create(PermissionRequest request) {
        return this.create(Arrays.asList(request));
    }

    public PermissionResponse create(final List<PermissionRequest> requests) {
        if (requests == null || requests.isEmpty()) {
            throw new IllegalArgumentException("Permission request must not be null or empty");
        }
        Callable<PermissionResponse> callable = new Callable<PermissionResponse>(){

            @Override
            public PermissionResponse call() throws Exception {
                return PermissionResource.this.http.post(PermissionResource.this.serverConfiguration.getPermissionEndpoint()).authorizationBearer(PermissionResource.this.pat.call()).json(JsonSerialization.writeValueAsBytes((Object)requests)).response().json(PermissionResponse.class).execute();
            }
        };
        try {
            return (PermissionResponse)callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Error creating permission ticket", cause);
        }
    }

    public PermissionTicketRepresentation create(final PermissionTicketRepresentation ticket) {
        if (ticket == null) {
            throw new IllegalArgumentException("Permission ticket must not be null or empty");
        }
        if (ticket.getRequester() == null && ticket.getRequesterName() == null) {
            throw new IllegalArgumentException("Permission ticket must have a requester");
        }
        if (ticket.getResource() == null && ticket.getResourceName() == null) {
            throw new IllegalArgumentException("Permission ticket must have a resource");
        }
        if (ticket.getScope() == null && ticket.getScopeName() == null) {
            throw new IllegalArgumentException("Permission ticket must have a scope");
        }
        Callable<PermissionTicketRepresentation> callable = new Callable<PermissionTicketRepresentation>(){

            @Override
            public PermissionTicketRepresentation call() throws Exception {
                return (PermissionTicketRepresentation)PermissionResource.this.http.post(PermissionResource.this.serverConfiguration.getPermissionEndpoint() + "/ticket").json(JsonSerialization.writeValueAsBytes((Object)ticket)).authorizationBearer(PermissionResource.this.pat.call()).response().json((TypeReference)new TypeReference<PermissionTicketRepresentation>(){}).execute();
            }
        };
        try {
            return (PermissionTicketRepresentation)callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Error updating permission ticket", cause);
        }
    }

    public List<PermissionTicketRepresentation> findByScope(final String scopeId) {
        if (scopeId == null) {
            throw new IllegalArgumentException("Scope id must not be null");
        }
        Callable<List<PermissionTicketRepresentation>> callable = new Callable<List<PermissionTicketRepresentation>>(){

            @Override
            public List<PermissionTicketRepresentation> call() throws Exception {
                return (List)PermissionResource.this.http.get(PermissionResource.this.serverConfiguration.getPermissionEndpoint() + "/ticket").authorizationBearer(PermissionResource.this.pat.call()).param("scopeId", scopeId).response().json((TypeReference)new TypeReference<List<PermissionTicketRepresentation>>(){}).execute();
            }
        };
        try {
            return (List)callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Error querying permission ticket by scope", cause);
        }
    }

    public List<PermissionTicketRepresentation> findByResource(final String resourceId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource id must not be null");
        }
        Callable<List<PermissionTicketRepresentation>> callable = new Callable<List<PermissionTicketRepresentation>>(){

            @Override
            public List<PermissionTicketRepresentation> call() throws Exception {
                return (List)PermissionResource.this.http.get(PermissionResource.this.serverConfiguration.getPermissionEndpoint() + "/ticket").authorizationBearer(PermissionResource.this.pat.call()).param("resourceId", resourceId).response().json((TypeReference)new TypeReference<List<PermissionTicketRepresentation>>(){}).execute();
            }
        };
        try {
            return (List)callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Error querying permission ticket by resource", cause);
        }
    }

    public List<PermissionTicketRepresentation> find(final String resourceId, final String scopeId, final String owner, final String requester, final Boolean granted, final Boolean returnNames, final Integer firstResult, final Integer maxResult) {
        Callable<List<PermissionTicketRepresentation>> callable = new Callable<List<PermissionTicketRepresentation>>(){

            @Override
            public List<PermissionTicketRepresentation> call() throws Exception {
                return (List)PermissionResource.this.http.get(PermissionResource.this.serverConfiguration.getPermissionEndpoint() + "/ticket").authorizationBearer(PermissionResource.this.pat.call()).param("resourceId", resourceId).param("scopeId", scopeId).param("owner", owner).param("requester", requester).param("granted", granted == null ? null : granted.toString()).param("returnNames", returnNames == null ? null : returnNames.toString()).param("first", firstResult == null ? null : firstResult.toString()).param("max", maxResult == null ? null : maxResult.toString()).response().json((TypeReference)new TypeReference<List<PermissionTicketRepresentation>>(){}).execute();
            }
        };
        try {
            return (List)callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Error querying permission ticket", cause);
        }
    }

    public void update(final PermissionTicketRepresentation ticket) {
        if (ticket == null) {
            throw new IllegalArgumentException("Permission ticket must not be null or empty");
        }
        if (ticket.getId() == null) {
            throw new IllegalArgumentException("Permission ticket must have an id");
        }
        Callable callable = new Callable(){

            public Object call() throws Exception {
                PermissionResource.this.http.put(PermissionResource.this.serverConfiguration.getPermissionEndpoint() + "/ticket").json(JsonSerialization.writeValueAsBytes((Object)ticket)).authorizationBearer(PermissionResource.this.pat.call()).response().json(List.class).execute();
                return null;
            }
        };
        try {
            callable.call();
        }
        catch (Exception cause) {
            Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Error updating permission ticket", cause);
        }
    }
}

