/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jaas;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.jaas.RolePrincipal;
import org.keycloak.adapters.rotation.AdapterTokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.FindFile;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.representations.AccessToken;

public abstract class AbstractKeycloakLoginModule
implements LoginModule {
    public static final String KEYCLOAK_CONFIG_FILE_OPTION = "keycloak-config-file";
    public static final String ROLE_PRINCIPAL_CLASS_OPTION = "role-principal-class";
    public static final String PROFILE_RESOURCE = "profile:";
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Auth auth;
    protected KeycloakDeployment deployment;
    protected String rolePrincipalClass;
    private static ConcurrentMap<String, KeycloakDeployment> deployments = new ConcurrentHashMap<String, KeycloakDeployment>();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        String configFile = (String)options.get(KEYCLOAK_CONFIG_FILE_OPTION);
        this.rolePrincipalClass = (String)options.get(ROLE_PRINCIPAL_CLASS_OPTION);
        this.getLogger().debug((Object)("Declared options: keycloak-config-file=" + configFile + ", " + ROLE_PRINCIPAL_CLASS_OPTION + "=" + this.rolePrincipalClass));
        if (configFile != null) {
            this.deployment = (KeycloakDeployment)deployments.get(configFile);
            if (this.deployment == null) {
                this.deployment = this.resolveDeployment(configFile);
                deployments.putIfAbsent(configFile, this.deployment);
            }
        }
    }

    protected KeycloakDeployment resolveDeployment(String keycloakConfigFile) {
        try {
            InputStream is = null;
            if (keycloakConfigFile.startsWith(PROFILE_RESOURCE)) {
                try {
                    is = new URL(keycloakConfigFile).openStream();
                }
                catch (MalformedURLException mfue) {
                    throw new RuntimeException(mfue);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            } else {
                is = FindFile.findFile((String)keycloakConfigFile);
            }
            KeycloakDeployment kd = KeycloakDeploymentBuilder.build(is);
            return kd;
        }
        catch (RuntimeException e) {
            this.getLogger().debug((Object)("Unable to find or parse file " + keycloakConfigFile + " due to " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("username"), new PasswordCallback("password", false)};
        try {
            this.callbackHandler.handle(callbacks);
            String username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            String password = new String(tmpPassword);
            ((PasswordCallback)callbacks[1]).clearPassword();
            Auth auth = this.doAuth(username, password);
            if (auth != null) {
                this.auth = auth;
                return true;
            }
            return false;
        }
        catch (UnsupportedCallbackException uce) {
            this.getLogger().warn((Object)("Error: " + uce.getCallback().toString() + " not available to gather authentication information from the user"));
            return false;
        }
        catch (Exception e) {
            LoginException le = new LoginException(e.toString());
            le.initCause(e);
            throw le;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.auth == null) {
            return false;
        }
        this.subject.getPrincipals().add((Principal)this.auth.getPrincipal());
        this.subject.getPrivateCredentials().add(this.auth.getTokenString());
        if (this.auth.getRoles() != null) {
            for (String roleName : this.auth.getRoles()) {
                Principal rolePrinc = this.createRolePrincipal(roleName);
                this.subject.getPrincipals().add(rolePrinc);
            }
        }
        return true;
    }

    protected Principal createRolePrincipal(String roleName) {
        if (this.rolePrincipalClass != null && this.rolePrincipalClass.length() > 0) {
            try {
                Class clazz = Reflections.classForName((String)this.rolePrincipalClass, (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()});
                Constructor constructor = clazz.getDeclaredConstructor(String.class);
                return (Principal)constructor.newInstance(roleName);
            }
            catch (Exception e) {
                this.getLogger().warn((Object)("Unable to create declared roleClass " + this.rolePrincipalClass + " due to " + e.getMessage()));
            }
        }
        return new RolePrincipal(roleName);
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        HashSet<Principal> principals = new HashSet<Principal>(this.subject.getPrincipals());
        for (Principal principal : principals) {
            if (!principal.getClass().equals(KeycloakPrincipal.class) && !principal.getClass().equals(RolePrincipal.class)) continue;
            this.subject.getPrincipals().remove(principal);
        }
        Set<Object> creds = this.subject.getPrivateCredentials();
        for (Object cred : creds) {
            this.subject.getPrivateCredentials().remove(cred);
        }
        this.subject = null;
        this.callbackHandler = null;
        return true;
    }

    protected Auth bearerAuth(String tokenString) throws VerificationException {
        AccessToken token = AdapterTokenVerifier.verifyToken(tokenString, this.deployment);
        return this.postTokenVerification(tokenString, token);
    }

    protected Auth postTokenVerification(String tokenString, AccessToken token) {
        boolean verifyCaller = this.deployment.isUseResourceRoleMappings() ? token.isVerifyCaller(this.deployment.getResourceName()) : token.isVerifyCaller();
        if (verifyCaller) {
            throw new IllegalStateException("VerifyCaller not supported yet in login module");
        }
        RefreshableKeycloakSecurityContext skSession = new RefreshableKeycloakSecurityContext(this.deployment, null, tokenString, token, null, null, null);
        String principalName = AdapterUtils.getPrincipalName(this.deployment, token);
        KeycloakPrincipal principal = new KeycloakPrincipal(principalName, (KeycloakSecurityContext)skSession);
        Set<String> roles = AdapterUtils.getRolesFromSecurityContext(skSession);
        return new Auth((KeycloakPrincipal<RefreshableKeycloakSecurityContext>)principal, roles, tokenString);
    }

    protected abstract Auth doAuth(String var1, String var2) throws Exception;

    protected abstract Logger getLogger();

    public static class Auth {
        private final KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal;
        private final Set<String> roles;
        private final String tokenString;

        public Auth(KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal, Set<String> roles, String accessToken) {
            this.principal = principal;
            this.roles = roles;
            this.tokenString = accessToken;
        }

        public KeycloakPrincipal<RefreshableKeycloakSecurityContext> getPrincipal() {
            return this.principal;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public String getTokenString() {
            return this.tokenString;
        }
    }
}

