/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.keycloak.common.Version;

public class Profile {
    private static ProfileValue value = Profile.load();

    static ProfileValue load() {
        String profile = null;
        try {
            File file;
            String jbossServerConfigDir;
            profile = System.getProperty("keycloak.profile");
            if (profile == null && (jbossServerConfigDir = System.getProperty("jboss.server.config.dir")) != null && (file = new File(jbossServerConfigDir, "profile.properties")).isFile()) {
                Properties props = new Properties();
                props.load(new FileInputStream(file));
                profile = props.getProperty("profile");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (profile == null) {
            return ProfileValue.valueOf(Version.DEFAULT_PROFILE.toUpperCase());
        }
        return ProfileValue.valueOf(profile.toUpperCase());
    }

    public static String getName() {
        return value.name().toLowerCase();
    }

    public static boolean isPreviewEnabled() {
        return value.ordinal() >= ProfileValue.PREVIEW.ordinal();
    }

    private static enum ProfileValue {
        PRODUCT,
        PREVIEW,
        COMMUNITY;

    }
}

