/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm.authorization;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.TokenIdGenerator;
import org.keycloak.json.StringListMapDeserializer;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;

public class PermissionTicketToken
extends JsonWebToken {
    private final List<ResourcePermission> resources;
    @JsonDeserialize(using=StringListMapDeserializer.class)
    private Map<String, List<String>> claims;

    public PermissionTicketToken() {
        this(new ArrayList<ResourcePermission>());
    }

    public PermissionTicketToken(List<ResourcePermission> resources, String audience, AccessToken accessToken) {
        if (accessToken != null) {
            this.id(TokenIdGenerator.generateId());
            this.subject(accessToken.getSubject());
            this.expiration(accessToken.getExpiration());
            this.notBefore(accessToken.getNotBefore());
            this.issuedAt(accessToken.getIssuedAt());
            this.issuedFor(accessToken.getIssuedFor());
        }
        if (audience != null) {
            this.audience(audience);
        }
        this.resources = resources;
    }

    public PermissionTicketToken(List<ResourcePermission> resources) {
        this(resources, null, null);
    }

    public List<ResourcePermission> getResources() {
        return this.resources;
    }

    public Map<String, List<String>> getClaims() {
        return this.claims;
    }

    public void setClaims(Map<String, List<String>> claims) {
        this.claims = claims;
    }

    public static class ResourcePermission {
        @JsonProperty(value="id")
        private String resourceId;
        @JsonProperty(value="scopes")
        private Set<String> scopes;

        public ResourcePermission() {
        }

        public ResourcePermission(String resourceId, Set<String> scopes) {
            this.resourceId = resourceId;
            this.scopes = scopes;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public Set<String> getScopes() {
            return this.scopes;
        }
    }
}

