/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.util;

import java.util.concurrent.Callable;
import org.jboss.logging.Logger;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.ServerConfiguration;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.RefreshToken;
import org.keycloak.util.JsonSerialization;

public class TokenCallable
implements Callable<String> {
    private static Logger log = Logger.getLogger(TokenCallable.class);
    private final String userName;
    private final String password;
    private final Http http;
    private final Configuration configuration;
    private final ServerConfiguration serverConfiguration;
    private AccessTokenResponse clientToken;

    public TokenCallable(String userName, String password, Http http, Configuration configuration, ServerConfiguration serverConfiguration) {
        this.userName = userName;
        this.password = password;
        this.http = http;
        this.configuration = configuration;
        this.serverConfiguration = serverConfiguration;
    }

    public TokenCallable(Http http, Configuration configuration, ServerConfiguration serverConfiguration) {
        this(null, null, http, configuration, serverConfiguration);
    }

    @Override
    public String call() {
        if (this.clientToken == null) {
            this.clientToken = this.userName == null || this.password == null ? this.obtainAccessToken() : this.obtainAccessToken(this.userName, this.password);
        } else {
            String refreshTokenValue = this.clientToken.getRefreshToken();
            try {
                RefreshToken refreshToken = (RefreshToken)JsonSerialization.readValue((byte[])new JWSInput(refreshTokenValue).getContent(), RefreshToken.class);
                if (!refreshToken.isActive() || !this.isTokenTimeToLiveSufficient((AccessToken)refreshToken)) {
                    log.debug((Object)"Refresh token is expired.");
                    this.clientToken = this.userName == null || this.password == null ? this.obtainAccessToken() : this.obtainAccessToken(this.userName, this.password);
                }
            }
            catch (Exception e) {
                this.clientToken = null;
                throw new RuntimeException(e);
            }
        }
        String token = this.clientToken.getToken();
        try {
            AccessToken accessToken = (AccessToken)JsonSerialization.readValue((byte[])new JWSInput(token).getContent(), AccessToken.class);
            if (accessToken.isActive() && this.isTokenTimeToLiveSufficient(accessToken)) {
                return token;
            }
            log.debug((Object)"Access token is expired.");
            this.clientToken = this.http.post(this.serverConfiguration.getTokenEndpoint()).authentication().client().form().param("grant_type", "refresh_token").param("refresh_token", this.clientToken.getRefreshToken()).response().json(AccessTokenResponse.class).execute();
        }
        catch (Exception e) {
            this.clientToken = null;
            throw new RuntimeException(e);
        }
        return this.clientToken.getToken();
    }

    public boolean isTokenTimeToLiveSufficient(AccessToken token) {
        return token != null && token.getExpiration() - this.getConfiguration().getTokenMinimumTimeToLive() > Time.currentTime();
    }

    AccessTokenResponse obtainAccessToken() {
        return this.http.post(this.serverConfiguration.getTokenEndpoint()).authentication().client().response().json(AccessTokenResponse.class).execute();
    }

    AccessTokenResponse obtainAccessToken(String userName, String password) {
        return this.http.post(this.serverConfiguration.getTokenEndpoint()).authentication().oauth2ResourceOwnerPassword(userName, password).response().json(AccessTokenResponse.class).execute();
    }

    Http getHttp() {
        return this.http;
    }

    protected boolean isRetry() {
        return true;
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    void clearToken() {
        this.clientToken = null;
    }
}

