/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import javax.crypto.Mac;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureException;
import org.keycloak.crypto.SignatureSignerContext;

public class MacSignatureSignerContext
implements SignatureSignerContext {
    private final KeyWrapper key;

    public MacSignatureSignerContext(KeyWrapper key) throws SignatureException {
        this.key = key;
    }

    @Override
    public String getKid() {
        return this.key.getKid();
    }

    @Override
    public String getAlgorithm() {
        return this.key.getAlgorithm();
    }

    @Override
    public byte[] sign(byte[] data) throws SignatureException {
        try {
            Mac mac = Mac.getInstance(JavaAlgorithm.getJavaAlgorithm(this.key.getAlgorithm()));
            mac.init(this.key.getSecretKey());
            mac.update(data);
            return mac.doFinal();
        }
        catch (Exception e) {
            throw new SignatureException("Signing failed", e);
        }
    }
}

